/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;

public class ListArtifactsIterable
implements SdkIterable<ListArtifactsResponse> {
    private final DeviceFarmClient client;
    private final ListArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArtifactsIterable(DeviceFarmClient client, ListArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public Iterator<ListArtifactsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Artifact> artifacts() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifacts() != null) {
                return response.artifacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListArtifactsIterable resume(ListArtifactsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListArtifactsIterable(this.client, (ListArtifactsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListArtifactsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListArtifactsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListArtifactsResponseFetcher
    implements SyncPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListArtifactsResponse nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsIterable.this.client.listArtifacts(ListArtifactsIterable.this.firstRequest);
            }
            return ListArtifactsIterable.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

