/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduleRunRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, ScheduleRunRequest> {
    private final String projectArn;
    private final String appArn;
    private final String devicePoolArn;
    private final String name;
    private final ScheduleRunTest test;
    private final ScheduleRunConfiguration configuration;
    private final ExecutionConfiguration executionConfiguration;

    private ScheduleRunRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.appArn = builder.appArn;
        this.devicePoolArn = builder.devicePoolArn;
        this.name = builder.name;
        this.test = builder.test;
        this.configuration = builder.configuration;
        this.executionConfiguration = builder.executionConfiguration;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String appArn() {
        return this.appArn;
    }

    public String devicePoolArn() {
        return this.devicePoolArn;
    }

    public String name() {
        return this.name;
    }

    public ScheduleRunTest test() {
        return this.test;
    }

    public ScheduleRunConfiguration configuration() {
        return this.configuration;
    }

    public ExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunRequest)) {
            return false;
        }
        ScheduleRunRequest other = (ScheduleRunRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.devicePoolArn(), other.devicePoolArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.executionConfiguration(), other.executionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleRunRequest").add("ProjectArn", (Object)this.projectArn()).add("AppArn", (Object)this.appArn()).add("DevicePoolArn", (Object)this.devicePoolArn()).add("Name", (Object)this.name()).add("Test", (Object)this.test()).add("Configuration", (Object)this.configuration()).add("ExecutionConfiguration", (Object)this.executionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.of(clazz.cast(this.projectArn()));
            }
            case "appArn": {
                return Optional.of(clazz.cast(this.appArn()));
            }
            case "devicePoolArn": {
                return Optional.of(clazz.cast(this.devicePoolArn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "test": {
                return Optional.of(clazz.cast(this.test()));
            }
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
            case "executionConfiguration": {
                return Optional.of(clazz.cast(this.executionConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String appArn;
        private String devicePoolArn;
        private String name;
        private ScheduleRunTest test;
        private ScheduleRunConfiguration configuration;
        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.appArn(model.appArn);
            this.devicePoolArn(model.devicePoolArn);
            this.name(model.name);
            this.test(model.test);
            this.configuration(model.configuration);
            this.executionConfiguration(model.executionConfiguration);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ScheduleRunTest.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public final ScheduleRunConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ScheduleRunConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return this.executionConfiguration != null ? this.executionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ScheduleRunRequest build() {
            return new ScheduleRunRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, ScheduleRunRequest> {
        public Builder projectArn(String var1);

        public Builder appArn(String var1);

        public Builder devicePoolArn(String var1);

        public Builder name(String var1);

        public Builder test(ScheduleRunTest var1);

        default public Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return this.test((ScheduleRunTest)((ScheduleRunTest.Builder)ScheduleRunTest.builder().apply(test)).build());
        }

        public Builder configuration(ScheduleRunConfiguration var1);

        default public Builder configuration(Consumer<ScheduleRunConfiguration.Builder> configuration) {
            return this.configuration((ScheduleRunConfiguration)((ScheduleRunConfiguration.Builder)ScheduleRunConfiguration.builder().apply(configuration)).build());
        }

        public Builder executionConfiguration(ExecutionConfiguration var1);

        default public Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return this.executionConfiguration((ExecutionConfiguration)((ExecutionConfiguration.Builder)ExecutionConfiguration.builder().apply(executionConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

