/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.SampleType;
import software.amazon.awssdk.services.devicefarm.transform.SampleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Sample
implements StructuredPojo,
ToCopyableBuilder<Builder, Sample> {
    private final String arn;
    private final String type;
    private final String url;

    private Sample(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.url = builder.url;
    }

    public String arn() {
        return this.arn;
    }

    public SampleType type() {
        return SampleType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"Sample").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SampleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Sample model) {
            this.arn(model.arn);
            this.type(model.type);
            this.url(model.url);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SampleType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public Sample build() {
            return new Sample(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Sample> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(SampleType var1);

        public Builder url(String var1);
    }
}

