/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RenewOfferingRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, RenewOfferingRequest> {
    private final String offeringId;
    private final Integer quantity;

    private RenewOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.offeringId = builder.offeringId;
        this.quantity = builder.quantity;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Integer quantity() {
        return this.quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewOfferingRequest)) {
            return false;
        }
        RenewOfferingRequest other = (RenewOfferingRequest)((Object)obj);
        return Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.quantity(), other.quantity());
    }

    public String toString() {
        return ToString.builder((String)"RenewOfferingRequest").add("OfferingId", (Object)this.offeringId()).add("Quantity", (Object)this.quantity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
            case "quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String offeringId;
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewOfferingRequest model) {
            super(model);
            this.offeringId(model.offeringId);
            this.quantity(model.quantity);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RenewOfferingRequest build() {
            return new RenewOfferingRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, RenewOfferingRequest> {
        public Builder offeringId(String var1);

        public Builder quantity(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

