/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ProjectMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Project
implements StructuredPojo,
ToCopyableBuilder<Builder, Project> {
    private final String arn;
    private final String name;
    private final Integer defaultJobTimeoutMinutes;
    private final Instant created;

    private Project(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
        this.created = builder.created;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Integer defaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public Instant created() {
        return this.created;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes()) && Objects.equals(this.created(), other.created());
    }

    public String toString() {
        return ToString.builder((String)"Project").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DefaultJobTimeoutMinutes", (Object)this.defaultJobTimeoutMinutes()).add("Created", (Object)this.created()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "defaultJobTimeoutMinutes": {
                return Optional.of(clazz.cast(this.defaultJobTimeoutMinutes()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Integer defaultJobTimeoutMinutes;
        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.arn(model.arn);
            this.name(model.name);
            this.defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
            this.created(model.created);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return this.defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public Project build() {
            return new Project(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Project> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder defaultJobTimeoutMinutes(Integer var1);

        public Builder created(Instant var1);
    }
}

