/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRemoteAccessSessionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
    private final List<RemoteAccessSession> remoteAccessSessions;
    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    public List<RemoteAccessSession> remoteAccessSessions() {
        return this.remoteAccessSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse)((Object)obj);
        return Objects.equals(this.remoteAccessSessions(), other.remoteAccessSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRemoteAccessSessionsResponse").add("RemoteAccessSessions", this.remoteAccessSessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteAccessSessions": {
                return Optional.of(clazz.cast(this.remoteAccessSessions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            super(model);
            this.remoteAccessSessions(model.remoteAccessSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<RemoteAccessSession.Builder> getRemoteAccessSessions() {
            return this.remoteAccessSessions != null ? (Collection)this.remoteAccessSessions.stream().map(RemoteAccessSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession ... remoteAccessSessions) {
            this.remoteAccessSessions(Arrays.asList(remoteAccessSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder> ... remoteAccessSessions) {
            this.remoteAccessSessions(Stream.of(remoteAccessSessions).map(c -> (RemoteAccessSession)((RemoteAccessSession.Builder)RemoteAccessSession.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession.BuilderImpl> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copyFromBuilder(remoteAccessSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        public Builder remoteAccessSessions(Collection<RemoteAccessSession> var1);

        public Builder remoteAccessSessions(RemoteAccessSession ... var1);

        public Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

