/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ArtifactsCopier;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListArtifactsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListArtifactsResponse> {
    private final List<Artifact> artifacts;
    private final String nextToken;

    private ListArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    public List<Artifact> artifacts() {
        return this.artifacts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArtifactsResponse)) {
            return false;
        }
        ListArtifactsResponse other = (ListArtifactsResponse)((Object)obj);
        return Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListArtifactsResponse").add("Artifacts", this.artifacts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifacts": {
                return Optional.of(clazz.cast(this.artifacts()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Artifact> artifacts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArtifactsResponse model) {
            super(model);
            this.artifacts(model.artifacts);
            this.nextToken(model.nextToken);
        }

        public final Collection<Artifact.Builder> getArtifacts() {
            return this.artifacts != null ? (Collection)this.artifacts.stream().map(Artifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder artifacts(Collection<Artifact> artifacts) {
            this.artifacts = ArtifactsCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Artifact ... artifacts) {
            this.artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<Artifact.Builder> ... artifacts) {
            this.artifacts(Stream.of(artifacts).map(c -> (Artifact)((Artifact.Builder)Artifact.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArtifacts(Collection<Artifact.BuilderImpl> artifacts) {
            this.artifacts = ArtifactsCopier.copyFromBuilder(artifacts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArtifactsResponse build() {
            return new ListArtifactsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListArtifactsResponse> {
        public Builder artifacts(Collection<Artifact> var1);

        public Builder artifacts(Artifact ... var1);

        public Builder artifacts(Consumer<Artifact.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

