/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDevicePoolCompatibilityRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
    private final String devicePoolArn;
    private final String appArn;
    private final String testType;
    private final ScheduleRunTest test;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        super(builder);
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
    }

    public String devicePoolArn() {
        return this.devicePoolArn;
    }

    public String appArn() {
        return this.appArn;
    }

    public TestType testType() {
        return TestType.fromValue(this.testType);
    }

    public String testTypeAsString() {
        return this.testType;
    }

    public ScheduleRunTest test() {
        return this.test;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest)((Object)obj);
        return Objects.equals(this.devicePoolArn(), other.devicePoolArn()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.testTypeAsString(), other.testTypeAsString()) && Objects.equals(this.test(), other.test());
    }

    public String toString() {
        return ToString.builder((String)"GetDevicePoolCompatibilityRequest").add("DevicePoolArn", (Object)this.devicePoolArn()).add("AppArn", (Object)this.appArn()).add("TestType", (Object)this.testTypeAsString()).add("Test", (Object)this.test()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devicePoolArn": {
                return Optional.of(clazz.cast(this.devicePoolArn()));
            }
            case "appArn": {
                return Optional.of(clazz.cast(this.appArn()));
            }
            case "testType": {
                return Optional.of(clazz.cast(this.testTypeAsString()));
            }
            case "test": {
                return Optional.of(clazz.cast(this.test()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String devicePoolArn;
        private String appArn;
        private String testType;
        private ScheduleRunTest test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            super(model);
            this.devicePoolArn(model.devicePoolArn);
            this.appArn(model.appArn);
            this.testType(model.testType);
            this.test(model.test);
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getTestType() {
            return this.testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType.toString());
            return this;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        public final ScheduleRunTest.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        public Builder devicePoolArn(String var1);

        public Builder appArn(String var1);

        public Builder testType(String var1);

        public Builder testType(TestType var1);

        public Builder test(ScheduleRunTest var1);

        default public Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return this.test((ScheduleRunTest)((ScheduleRunTest.Builder)ScheduleRunTest.builder().apply(test)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

