/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.MaxSlotMapCopier;
import software.amazon.awssdk.services.devicefarm.model.PurchasedDevicesMapCopier;
import software.amazon.awssdk.services.devicefarm.model.TrialMinutes;
import software.amazon.awssdk.services.devicefarm.transform.AccountSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountSettings> {
    private final String awsAccountNumber;
    private final Map<String, Integer> unmeteredDevices;
    private final Map<String, Integer> unmeteredRemoteAccessDevices;
    private final Integer maxJobTimeoutMinutes;
    private final TrialMinutes trialMinutes;
    private final Map<String, Integer> maxSlots;
    private final Integer defaultJobTimeoutMinutes;

    private AccountSettings(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.unmeteredDevices = builder.unmeteredDevices;
        this.unmeteredRemoteAccessDevices = builder.unmeteredRemoteAccessDevices;
        this.maxJobTimeoutMinutes = builder.maxJobTimeoutMinutes;
        this.trialMinutes = builder.trialMinutes;
        this.maxSlots = builder.maxSlots;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    public String awsAccountNumber() {
        return this.awsAccountNumber;
    }

    public Map<DevicePlatform, Integer> unmeteredDevices() {
        return TypeConverter.convert(this.unmeteredDevices, DevicePlatform::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)DevicePlatform.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, Integer> unmeteredDevicesAsStrings() {
        return this.unmeteredDevices;
    }

    public Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices() {
        return TypeConverter.convert(this.unmeteredRemoteAccessDevices, DevicePlatform::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)DevicePlatform.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, Integer> unmeteredRemoteAccessDevicesAsStrings() {
        return this.unmeteredRemoteAccessDevices;
    }

    public Integer maxJobTimeoutMinutes() {
        return this.maxJobTimeoutMinutes;
    }

    public TrialMinutes trialMinutes() {
        return this.trialMinutes;
    }

    public Map<String, Integer> maxSlots() {
        return this.maxSlots;
    }

    public Integer defaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmeteredDevicesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmeteredRemoteAccessDevicesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSlots());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultJobTimeoutMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        return Objects.equals(this.awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(this.unmeteredDevicesAsStrings(), other.unmeteredDevicesAsStrings()) && Objects.equals(this.unmeteredRemoteAccessDevicesAsStrings(), other.unmeteredRemoteAccessDevicesAsStrings()) && Objects.equals(this.maxJobTimeoutMinutes(), other.maxJobTimeoutMinutes()) && Objects.equals(this.trialMinutes(), other.trialMinutes()) && Objects.equals(this.maxSlots(), other.maxSlots()) && Objects.equals(this.defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes());
    }

    public String toString() {
        return ToString.builder((String)"AccountSettings").add("AwsAccountNumber", (Object)this.awsAccountNumber()).add("UnmeteredDevices", this.unmeteredDevicesAsStrings()).add("UnmeteredRemoteAccessDevices", this.unmeteredRemoteAccessDevicesAsStrings()).add("MaxJobTimeoutMinutes", (Object)this.maxJobTimeoutMinutes()).add("TrialMinutes", (Object)this.trialMinutes()).add("MaxSlots", this.maxSlots()).add("DefaultJobTimeoutMinutes", (Object)this.defaultJobTimeoutMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountNumber": {
                return Optional.of(clazz.cast(this.awsAccountNumber()));
            }
            case "unmeteredDevices": {
                return Optional.of(clazz.cast(this.unmeteredDevicesAsStrings()));
            }
            case "unmeteredRemoteAccessDevices": {
                return Optional.of(clazz.cast(this.unmeteredRemoteAccessDevicesAsStrings()));
            }
            case "maxJobTimeoutMinutes": {
                return Optional.of(clazz.cast(this.maxJobTimeoutMinutes()));
            }
            case "trialMinutes": {
                return Optional.of(clazz.cast(this.trialMinutes()));
            }
            case "maxSlots": {
                return Optional.of(clazz.cast(this.maxSlots()));
            }
            case "defaultJobTimeoutMinutes": {
                return Optional.of(clazz.cast(this.defaultJobTimeoutMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountNumber;
        private Map<String, Integer> unmeteredDevices;
        private Map<String, Integer> unmeteredRemoteAccessDevices;
        private Integer maxJobTimeoutMinutes;
        private TrialMinutes trialMinutes;
        private Map<String, Integer> maxSlots;
        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            this.awsAccountNumber(model.awsAccountNumber);
            this.unmeteredDevices(model.unmeteredDevices);
            this.unmeteredRemoteAccessDevices(model.unmeteredRemoteAccessDevices);
            this.maxJobTimeoutMinutes(model.maxJobTimeoutMinutes);
            this.trialMinutes(model.trialMinutes);
            this.maxSlots(model.maxSlots);
            this.defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getAwsAccountNumber() {
            return this.awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final Map<String, Integer> getUnmeteredDevices() {
            return this.unmeteredDevices;
        }

        @Override
        public final Builder unmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
            return this;
        }

        public final void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
        }

        public final Map<String, Integer> getUnmeteredRemoteAccessDevices() {
            return this.unmeteredRemoteAccessDevices;
        }

        @Override
        public final Builder unmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
            return this;
        }

        public final void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
        }

        public final Integer getMaxJobTimeoutMinutes() {
            return this.maxJobTimeoutMinutes;
        }

        @Override
        public final Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
            return this;
        }

        public final void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
        }

        public final TrialMinutes.Builder getTrialMinutes() {
            return this.trialMinutes != null ? this.trialMinutes.toBuilder() : null;
        }

        @Override
        public final Builder trialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
            return this;
        }

        public final void setTrialMinutes(TrialMinutes.BuilderImpl trialMinutes) {
            this.trialMinutes = trialMinutes != null ? trialMinutes.build() : null;
        }

        public final Map<String, Integer> getMaxSlots() {
            return this.maxSlots;
        }

        @Override
        public final Builder maxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
            return this;
        }

        public final void setMaxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return this.defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        public AccountSettings build() {
            return new AccountSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountSettings> {
        public Builder awsAccountNumber(String var1);

        public Builder unmeteredDevices(Map<String, Integer> var1);

        public Builder unmeteredRemoteAccessDevices(Map<String, Integer> var1);

        public Builder maxJobTimeoutMinutes(Integer var1);

        public Builder trialMinutes(TrialMinutes var1);

        default public Builder trialMinutes(Consumer<TrialMinutes.Builder> trialMinutes) {
            return this.trialMinutes((TrialMinutes)((TrialMinutes.Builder)TrialMinutes.builder().apply(trialMinutes)).build());
        }

        public Builder maxSlots(Map<String, Integer> var1);

        public Builder defaultJobTimeoutMinutes(Integer var1);
    }
}

