/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;

@SdkInternalApi
public class MonetaryAmountMarshaller {
    private static final MarshallingInfo<Double> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amount").build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currencyCode").build();
    private static final MonetaryAmountMarshaller instance = new MonetaryAmountMarshaller();

    public static MonetaryAmountMarshaller getInstance() {
        return instance;
    }

    public void marshall(MonetaryAmount monetaryAmount, ProtocolMarshaller protocolMarshaller) {
        if (monetaryAmount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)monetaryAmount.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)monetaryAmount.currencyCode(), CURRENCYCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

