/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ExecutionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExecutionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ExecutionConfiguration> {
    private final Integer jobTimeoutMinutes;
    private final Boolean accountsCleanup;
    private final Boolean appPackagesCleanup;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
    }

    public Integer jobTimeoutMinutes() {
        return this.jobTimeoutMinutes;
    }

    public Boolean accountsCleanup() {
        return this.accountsCleanup;
    }

    public Boolean appPackagesCleanup() {
        return this.appPackagesCleanup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobTimeoutMinutes() == null ? 0 : this.jobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + (this.accountsCleanup() == null ? 0 : this.accountsCleanup().hashCode());
        hashCode = 31 * hashCode + (this.appPackagesCleanup() == null ? 0 : this.appPackagesCleanup().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration)obj;
        if (other.jobTimeoutMinutes() == null ^ this.jobTimeoutMinutes() == null) {
            return false;
        }
        if (other.jobTimeoutMinutes() != null && !other.jobTimeoutMinutes().equals(this.jobTimeoutMinutes())) {
            return false;
        }
        if (other.accountsCleanup() == null ^ this.accountsCleanup() == null) {
            return false;
        }
        if (other.accountsCleanup() != null && !other.accountsCleanup().equals(this.accountsCleanup())) {
            return false;
        }
        if (other.appPackagesCleanup() == null ^ this.appPackagesCleanup() == null) {
            return false;
        }
        return other.appPackagesCleanup() == null || other.appPackagesCleanup().equals(this.appPackagesCleanup());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobTimeoutMinutes() != null) {
            sb.append("JobTimeoutMinutes: ").append(this.jobTimeoutMinutes()).append(",");
        }
        if (this.accountsCleanup() != null) {
            sb.append("AccountsCleanup: ").append(this.accountsCleanup()).append(",");
        }
        if (this.appPackagesCleanup() != null) {
            sb.append("AppPackagesCleanup: ").append(this.appPackagesCleanup()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer jobTimeoutMinutes;
        private Boolean accountsCleanup;
        private Boolean appPackagesCleanup;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            this.setJobTimeoutMinutes(model.jobTimeoutMinutes);
            this.setAccountsCleanup(model.accountsCleanup);
            this.setAppPackagesCleanup(model.appPackagesCleanup);
        }

        public final Integer getJobTimeoutMinutes() {
            return this.jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        public final Boolean getAccountsCleanup() {
            return this.accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        public final Boolean getAppPackagesCleanup() {
            return this.appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutionConfiguration> {
        public Builder jobTimeoutMinutes(Integer var1);

        public Builder accountsCleanup(Boolean var1);

        public Builder appPackagesCleanup(Boolean var1);
    }
}

