/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DatasourcePackage;
import software.amazon.awssdk.services.detective.model.DatasourcePackageListCopier;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasourcePackagesRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, UpdateDatasourcePackagesRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(UpdateDatasourcePackagesRequest.getter(UpdateDatasourcePackagesRequest::graphArn)).setter(UpdateDatasourcePackagesRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<List<String>> DATASOURCE_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasourcePackages").getter(UpdateDatasourcePackagesRequest.getter(UpdateDatasourcePackagesRequest::datasourcePackagesAsStrings)).setter(UpdateDatasourcePackagesRequest.setter(Builder::datasourcePackagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, DATASOURCE_PACKAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDatasourcePackagesRequest.memberNameToFieldInitializer();
    private final String graphArn;
    private final List<String> datasourcePackages;

    private UpdateDatasourcePackagesRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.datasourcePackages = builder.datasourcePackages;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final List<DatasourcePackage> datasourcePackages() {
        return DatasourcePackageListCopier.copyStringToEnum(this.datasourcePackages);
    }

    public final boolean hasDatasourcePackages() {
        return this.datasourcePackages != null && !(this.datasourcePackages instanceof SdkAutoConstructList);
    }

    public final List<String> datasourcePackagesAsStrings() {
        return this.datasourcePackages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasourcePackages() ? this.datasourcePackagesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasourcePackagesRequest)) {
            return false;
        }
        UpdateDatasourcePackagesRequest other = (UpdateDatasourcePackagesRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && this.hasDatasourcePackages() == other.hasDatasourcePackages() && Objects.equals(this.datasourcePackagesAsStrings(), other.datasourcePackagesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasourcePackagesRequest").add("GraphArn", (Object)this.graphArn()).add("DatasourcePackages", this.hasDatasourcePackages() ? this.datasourcePackagesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "DatasourcePackages": {
                return Optional.ofNullable(clazz.cast(this.datasourcePackagesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("DatasourcePackages", DATASOURCE_PACKAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasourcePackagesRequest, T> g) {
        return obj -> g.apply((UpdateDatasourcePackagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private List<String> datasourcePackages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasourcePackagesRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.datasourcePackagesWithStrings(model.datasourcePackages);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Collection<String> getDatasourcePackages() {
            if (this.datasourcePackages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasourcePackages;
        }

        public final void setDatasourcePackages(Collection<String> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copy(datasourcePackages);
        }

        @Override
        public final Builder datasourcePackagesWithStrings(Collection<String> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copy(datasourcePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasourcePackagesWithStrings(String ... datasourcePackages) {
            this.datasourcePackagesWithStrings(Arrays.asList(datasourcePackages));
            return this;
        }

        @Override
        public final Builder datasourcePackages(Collection<DatasourcePackage> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageListCopier.copyEnumToString(datasourcePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasourcePackages(DatasourcePackage ... datasourcePackages) {
            this.datasourcePackages(Arrays.asList(datasourcePackages));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasourcePackagesRequest build() {
            return new UpdateDatasourcePackagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasourcePackagesRequest> {
        public Builder graphArn(String var1);

        public Builder datasourcePackagesWithStrings(Collection<String> var1);

        public Builder datasourcePackagesWithStrings(String ... var1);

        public Builder datasourcePackages(Collection<DatasourcePackage> var1);

        public Builder datasourcePackages(DatasourcePackage ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

