/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveException;
import software.amazon.awssdk.services.detective.model.ErrorCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessDeniedException
extends DetectiveException
implements ToCopyableBuilder<Builder, AccessDeniedException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(AccessDeniedException.getter(AccessDeniedException::errorCodeAsString)).setter(AccessDeniedException.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_CODE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCodeReason").getter(AccessDeniedException.getter(AccessDeniedException::errorCodeReason)).setter(AccessDeniedException.setter(Builder::errorCodeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCodeReason").build()}).build();
    private static final SdkField<String> SUB_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubErrorCode").getter(AccessDeniedException.getter(AccessDeniedException::subErrorCodeAsString)).setter(AccessDeniedException.setter(Builder::subErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubErrorCode").build()}).build();
    private static final SdkField<String> SUB_ERROR_CODE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubErrorCodeReason").getter(AccessDeniedException.getter(AccessDeniedException::subErrorCodeReason)).setter(AccessDeniedException.setter(Builder::subErrorCodeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubErrorCodeReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_CODE_REASON_FIELD, SUB_ERROR_CODE_FIELD, SUB_ERROR_CODE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessDeniedException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String errorCodeReason;
    private final String subErrorCode;
    private final String subErrorCodeReason;

    private AccessDeniedException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorCodeReason = builder.errorCodeReason;
        this.subErrorCode = builder.subErrorCode;
        this.subErrorCodeReason = builder.subErrorCodeReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorCodeReason() {
        return this.errorCodeReason;
    }

    public ErrorCode subErrorCode() {
        return ErrorCode.fromValue(this.subErrorCode);
    }

    public String subErrorCodeAsString() {
        return this.subErrorCode;
    }

    public String subErrorCodeReason() {
        return this.subErrorCodeReason;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorCodeReason", ERROR_CODE_REASON_FIELD);
        map.put("SubErrorCode", SUB_ERROR_CODE_FIELD);
        map.put("SubErrorCodeReason", SUB_ERROR_CODE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessDeniedException, T> g) {
        return obj -> g.apply((AccessDeniedException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveException.BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorCodeReason;
        private String subErrorCode;
        private String subErrorCodeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDeniedException model) {
            super(model);
            this.errorCode(model.errorCode);
            this.errorCodeReason(model.errorCodeReason);
            this.subErrorCode(model.subErrorCode);
            this.subErrorCodeReason(model.subErrorCodeReason);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorCodeReason() {
            return this.errorCodeReason;
        }

        public final void setErrorCodeReason(String errorCodeReason) {
            this.errorCodeReason = errorCodeReason;
        }

        @Override
        public final Builder errorCodeReason(String errorCodeReason) {
            this.errorCodeReason = errorCodeReason;
            return this;
        }

        public final String getSubErrorCode() {
            return this.subErrorCode;
        }

        public final void setSubErrorCode(String subErrorCode) {
            this.subErrorCode = subErrorCode;
        }

        @Override
        public final Builder subErrorCode(String subErrorCode) {
            this.subErrorCode = subErrorCode;
            return this;
        }

        @Override
        public final Builder subErrorCode(ErrorCode subErrorCode) {
            this.subErrorCode(subErrorCode == null ? null : subErrorCode.toString());
            return this;
        }

        public final String getSubErrorCodeReason() {
            return this.subErrorCodeReason;
        }

        public final void setSubErrorCodeReason(String subErrorCodeReason) {
            this.subErrorCodeReason = subErrorCodeReason;
        }

        @Override
        public final Builder subErrorCodeReason(String subErrorCodeReason) {
            this.subErrorCodeReason = subErrorCodeReason;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public AccessDeniedException build() {
            return new AccessDeniedException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessDeniedException>,
    DetectiveException.Builder {
        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder errorCodeReason(String var1);

        public Builder subErrorCode(String var1);

        public Builder subErrorCode(ErrorCode var1);

        public Builder subErrorCodeReason(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

