/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.detective.model.DatasourcePackage;
import software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail;
import software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetailsCopier;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasourcePackagesResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListDatasourcePackagesResponse> {
    private static final SdkField<Map<String, DatasourcePackageIngestDetail>> DATASOURCE_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DatasourcePackages").getter(ListDatasourcePackagesResponse.getter(ListDatasourcePackagesResponse::datasourcePackagesAsStrings)).setter(ListDatasourcePackagesResponse.setter(Builder::datasourcePackagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackages").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasourcePackageIngestDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasourcePackagesResponse.getter(ListDatasourcePackagesResponse::nextToken)).setter(ListDatasourcePackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASOURCE_PACKAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDatasourcePackagesResponse.memberNameToFieldInitializer();
    private final Map<String, DatasourcePackageIngestDetail> datasourcePackages;
    private final String nextToken;

    private ListDatasourcePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.datasourcePackages = builder.datasourcePackages;
        this.nextToken = builder.nextToken;
    }

    public final Map<DatasourcePackage, DatasourcePackageIngestDetail> datasourcePackages() {
        return DatasourcePackageIngestDetailsCopier.copyStringToEnum(this.datasourcePackages);
    }

    public final boolean hasDatasourcePackages() {
        return this.datasourcePackages != null && !(this.datasourcePackages instanceof SdkAutoConstructMap);
    }

    public final Map<String, DatasourcePackageIngestDetail> datasourcePackagesAsStrings() {
        return this.datasourcePackages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasourcePackages() ? this.datasourcePackagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasourcePackagesResponse)) {
            return false;
        }
        ListDatasourcePackagesResponse other = (ListDatasourcePackagesResponse)((Object)obj);
        return this.hasDatasourcePackages() == other.hasDatasourcePackages() && Objects.equals(this.datasourcePackagesAsStrings(), other.datasourcePackagesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasourcePackagesResponse").add("DatasourcePackages", this.hasDatasourcePackages() ? this.datasourcePackagesAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasourcePackages": {
                return Optional.ofNullable(clazz.cast(this.datasourcePackagesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasourcePackages", DATASOURCE_PACKAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasourcePackagesResponse, T> g) {
        return obj -> g.apply((ListDatasourcePackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private Map<String, DatasourcePackageIngestDetail> datasourcePackages = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasourcePackagesResponse model) {
            super(model);
            this.datasourcePackagesWithStrings(model.datasourcePackages);
            this.nextToken(model.nextToken);
        }

        public final Map<String, DatasourcePackageIngestDetail.Builder> getDatasourcePackages() {
            Map<String, DatasourcePackageIngestDetail.Builder> result = DatasourcePackageIngestDetailsCopier.copyToBuilder(this.datasourcePackages);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDatasourcePackages(Map<String, DatasourcePackageIngestDetail.BuilderImpl> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copyFromBuilder(datasourcePackages);
        }

        @Override
        public final Builder datasourcePackagesWithStrings(Map<String, DatasourcePackageIngestDetail> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copy(datasourcePackages);
            return this;
        }

        @Override
        public final Builder datasourcePackages(Map<DatasourcePackage, DatasourcePackageIngestDetail> datasourcePackages) {
            this.datasourcePackages = DatasourcePackageIngestDetailsCopier.copyEnumToString(datasourcePackages);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasourcePackagesResponse build() {
            return new ListDatasourcePackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasourcePackagesResponse> {
        public Builder datasourcePackagesWithStrings(Map<String, DatasourcePackageIngestDetail> var1);

        public Builder datasourcePackages(Map<DatasourcePackage, DatasourcePackageIngestDetail> var1);

        public Builder nextToken(String var1);
    }
}

