/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.Account;
import software.amazon.awssdk.services.detective.model.AccountListCopier;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembersRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, CreateMembersRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(CreateMembersRequest.getter(CreateMembersRequest::graphArn)).setter(CreateMembersRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(CreateMembersRequest.getter(CreateMembersRequest::message)).setter(CreateMembersRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Boolean> DISABLE_EMAIL_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableEmailNotification").getter(CreateMembersRequest.getter(CreateMembersRequest::disableEmailNotification)).setter(CreateMembersRequest.setter(Builder::disableEmailNotification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableEmailNotification").build()}).build();
    private static final SdkField<List<Account>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(CreateMembersRequest.getter(CreateMembersRequest::accounts)).setter(CreateMembersRequest.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Account::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, MESSAGE_FIELD, DISABLE_EMAIL_NOTIFICATION_FIELD, ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMembersRequest.memberNameToFieldInitializer();
    private final String graphArn;
    private final String message;
    private final Boolean disableEmailNotification;
    private final List<Account> accounts;

    private CreateMembersRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.message = builder.message;
        this.disableEmailNotification = builder.disableEmailNotification;
        this.accounts = builder.accounts;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String message() {
        return this.message;
    }

    public final Boolean disableEmailNotification() {
        return this.disableEmailNotification;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<Account> accounts() {
        return this.accounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableEmailNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersRequest)) {
            return false;
        }
        CreateMembersRequest other = (CreateMembersRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.disableEmailNotification(), other.disableEmailNotification()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMembersRequest").add("GraphArn", (Object)this.graphArn()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("DisableEmailNotification", (Object)this.disableEmailNotification()).add("Accounts", this.hasAccounts() ? this.accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "DisableEmailNotification": {
                return Optional.ofNullable(clazz.cast(this.disableEmailNotification()));
            }
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("DisableEmailNotification", DISABLE_EMAIL_NOTIFICATION_FIELD);
        map.put("Accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersRequest, T> g) {
        return obj -> g.apply((CreateMembersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private String message;
        private Boolean disableEmailNotification;
        private List<Account> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.message(model.message);
            this.disableEmailNotification(model.disableEmailNotification);
            this.accounts(model.accounts);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Boolean getDisableEmailNotification() {
            return this.disableEmailNotification;
        }

        public final void setDisableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
        }

        @Override
        public final Builder disableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        public final List<Account.Builder> getAccounts() {
            List<Account.Builder> result = AccountListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<Account.BuilderImpl> accounts) {
            this.accounts = AccountListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<Account> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Account ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<Account.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (Account)((Account.Builder)Account.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembersRequest build() {
            return new CreateMembersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembersRequest> {
        public Builder graphArn(String var1);

        public Builder message(String var1);

        public Builder disableEmailNotification(Boolean var1);

        public Builder accounts(Collection<Account> var1);

        public Builder accounts(Account ... var1);

        public Builder accounts(Consumer<Account.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

