/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.Administrator;
import software.amazon.awssdk.services.detective.model.AdministratorListCopier;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationAdminAccountsResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
    private static final SdkField<List<Administrator>> ADMINISTRATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Administrators").getter(ListOrganizationAdminAccountsResponse.getter(ListOrganizationAdminAccountsResponse::administrators)).setter(ListOrganizationAdminAccountsResponse.setter(Builder::administrators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Administrators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Administrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationAdminAccountsResponse.getter(ListOrganizationAdminAccountsResponse::nextToken)).setter(ListOrganizationAdminAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOrganizationAdminAccountsResponse.memberNameToFieldInitializer();
    private final List<Administrator> administrators;
    private final String nextToken;

    private ListOrganizationAdminAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.administrators = builder.administrators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAdministrators() {
        return this.administrators != null && !(this.administrators instanceof SdkAutoConstructList);
    }

    public final List<Administrator> administrators() {
        return this.administrators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdministrators() ? this.administrators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationAdminAccountsResponse)) {
            return false;
        }
        ListOrganizationAdminAccountsResponse other = (ListOrganizationAdminAccountsResponse)((Object)obj);
        return this.hasAdministrators() == other.hasAdministrators() && Objects.equals(this.administrators(), other.administrators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationAdminAccountsResponse").add("Administrators", this.hasAdministrators() ? this.administrators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Administrators": {
                return Optional.ofNullable(clazz.cast(this.administrators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Administrators", ADMINISTRATORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationAdminAccountsResponse, T> g) {
        return obj -> g.apply((ListOrganizationAdminAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<Administrator> administrators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationAdminAccountsResponse model) {
            super(model);
            this.administrators(model.administrators);
            this.nextToken(model.nextToken);
        }

        public final List<Administrator.Builder> getAdministrators() {
            List<Administrator.Builder> result = AdministratorListCopier.copyToBuilder(this.administrators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrators(Collection<Administrator.BuilderImpl> administrators) {
            this.administrators = AdministratorListCopier.copyFromBuilder(administrators);
        }

        @Override
        public final Builder administrators(Collection<Administrator> administrators) {
            this.administrators = AdministratorListCopier.copy(administrators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrators(Administrator ... administrators) {
            this.administrators(Arrays.asList(administrators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrators(Consumer<Administrator.Builder> ... administrators) {
            this.administrators(Stream.of(administrators).map(c -> (Administrator)((Administrator.Builder)Administrator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationAdminAccountsResponse build() {
            return new ListOrganizationAdminAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
        public Builder administrators(Collection<Administrator> var1);

        public Builder administrators(Administrator ... var1);

        public Builder administrators(Consumer<Administrator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

