/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.services.detective.model.GraphArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMembershipDatasourcesRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, BatchGetMembershipDatasourcesRequest> {
    private static final SdkField<List<String>> GRAPH_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GraphArns").getter(BatchGetMembershipDatasourcesRequest.getter(BatchGetMembershipDatasourcesRequest::graphArns)).setter(BatchGetMembershipDatasourcesRequest.setter(Builder::graphArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GraphArns", GRAPH_ARNS_FIELD);
        }
    });
    private final List<String> graphArns;

    private BatchGetMembershipDatasourcesRequest(BuilderImpl builder) {
        super(builder);
        this.graphArns = builder.graphArns;
    }

    public final boolean hasGraphArns() {
        return this.graphArns != null && !(this.graphArns instanceof SdkAutoConstructList);
    }

    public final List<String> graphArns() {
        return this.graphArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGraphArns() ? this.graphArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMembershipDatasourcesRequest)) {
            return false;
        }
        BatchGetMembershipDatasourcesRequest other = (BatchGetMembershipDatasourcesRequest)((Object)obj);
        return this.hasGraphArns() == other.hasGraphArns() && Objects.equals(this.graphArns(), other.graphArns());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMembershipDatasourcesRequest").add("GraphArns", this.hasGraphArns() ? this.graphArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArns": {
                return Optional.ofNullable(clazz.cast(this.graphArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMembershipDatasourcesRequest, T> g) {
        return obj -> g.apply((BatchGetMembershipDatasourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private List<String> graphArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMembershipDatasourcesRequest model) {
            super(model);
            this.graphArns(model.graphArns);
        }

        public final Collection<String> getGraphArns() {
            if (this.graphArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.graphArns;
        }

        public final void setGraphArns(Collection<String> graphArns) {
            this.graphArns = GraphArnListCopier.copy(graphArns);
        }

        @Override
        public final Builder graphArns(Collection<String> graphArns) {
            this.graphArns = GraphArnListCopier.copy(graphArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphArns(String ... graphArns) {
            this.graphArns(Arrays.asList(graphArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetMembershipDatasourcesRequest build() {
            return new BatchGetMembershipDatasourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMembershipDatasourcesRequest> {
        public Builder graphArns(Collection<String> var1);

        public Builder graphArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

