/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasourcePackageUsageInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasourcePackageUsageInfo> {
    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeUsageInBytes").getter(DatasourcePackageUsageInfo.getter(DatasourcePackageUsageInfo::volumeUsageInBytes)).setter(DatasourcePackageUsageInfo.setter(Builder::volumeUsageInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build()}).build();
    private static final SdkField<Instant> VOLUME_USAGE_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("VolumeUsageUpdateTime").getter(DatasourcePackageUsageInfo.getter(DatasourcePackageUsageInfo::volumeUsageUpdateTime)).setter(DatasourcePackageUsageInfo.setter(Builder::volumeUsageUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageUpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_USAGE_IN_BYTES_FIELD, VOLUME_USAGE_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VolumeUsageInBytes", VOLUME_USAGE_IN_BYTES_FIELD);
            this.put("VolumeUsageUpdateTime", VOLUME_USAGE_UPDATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long volumeUsageInBytes;
    private final Instant volumeUsageUpdateTime;

    private DatasourcePackageUsageInfo(BuilderImpl builder) {
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeUsageUpdateTime = builder.volumeUsageUpdateTime;
    }

    public final Long volumeUsageInBytes() {
        return this.volumeUsageInBytes;
    }

    public final Instant volumeUsageUpdateTime() {
        return this.volumeUsageUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeUsageUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcePackageUsageInfo)) {
            return false;
        }
        DatasourcePackageUsageInfo other = (DatasourcePackageUsageInfo)obj;
        return Objects.equals(this.volumeUsageInBytes(), other.volumeUsageInBytes()) && Objects.equals(this.volumeUsageUpdateTime(), other.volumeUsageUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DatasourcePackageUsageInfo").add("VolumeUsageInBytes", (Object)this.volumeUsageInBytes()).add("VolumeUsageUpdateTime", (Object)this.volumeUsageUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeUsageInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeUsageInBytes()));
            }
            case "VolumeUsageUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.volumeUsageUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasourcePackageUsageInfo, T> g) {
        return obj -> g.apply((DatasourcePackageUsageInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long volumeUsageInBytes;
        private Instant volumeUsageUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasourcePackageUsageInfo model) {
            this.volumeUsageInBytes(model.volumeUsageInBytes);
            this.volumeUsageUpdateTime(model.volumeUsageUpdateTime);
        }

        public final Long getVolumeUsageInBytes() {
            return this.volumeUsageInBytes;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        @Override
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final Instant getVolumeUsageUpdateTime() {
            return this.volumeUsageUpdateTime;
        }

        public final void setVolumeUsageUpdateTime(Instant volumeUsageUpdateTime) {
            this.volumeUsageUpdateTime = volumeUsageUpdateTime;
        }

        @Override
        public final Builder volumeUsageUpdateTime(Instant volumeUsageUpdateTime) {
            this.volumeUsageUpdateTime = volumeUsageUpdateTime;
            return this;
        }

        public DatasourcePackageUsageInfo build() {
            return new DatasourcePackageUsageInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasourcePackageUsageInfo> {
        public Builder volumeUsageInBytes(Long var1);

        public Builder volumeUsageUpdateTime(Instant var1);
    }
}

