/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Administrator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Administrator> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Administrator.getter(Administrator::accountId)).setter(Administrator.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(Administrator.getter(Administrator::graphArn)).setter(Administrator.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<Instant> DELEGATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DelegationTime").getter(Administrator.getter(Administrator::delegationTime)).setter(Administrator.setter(Builder::delegationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, GRAPH_ARN_FIELD, DELEGATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("GraphArn", GRAPH_ARN_FIELD);
            this.put("DelegationTime", DELEGATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String graphArn;
    private final Instant delegationTime;

    private Administrator(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.graphArn = builder.graphArn;
        this.delegationTime = builder.delegationTime;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final Instant delegationTime() {
        return this.delegationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Administrator)) {
            return false;
        }
        Administrator other = (Administrator)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.delegationTime(), other.delegationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Administrator").add("AccountId", (Object)this.accountId()).add("GraphArn", (Object)this.graphArn()).add("DelegationTime", (Object)this.delegationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "DelegationTime": {
                return Optional.ofNullable(clazz.cast(this.delegationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Administrator, T> g) {
        return obj -> g.apply((Administrator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String graphArn;
        private Instant delegationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Administrator model) {
            this.accountId(model.accountId);
            this.graphArn(model.graphArn);
            this.delegationTime(model.delegationTime);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Instant getDelegationTime() {
            return this.delegationTime;
        }

        public final void setDelegationTime(Instant delegationTime) {
            this.delegationTime = delegationTime;
        }

        @Override
        public final Builder delegationTime(Instant delegationTime) {
            this.delegationTime = delegationTime;
            return this;
        }

        public Administrator build() {
            return new Administrator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Administrator> {
        public Builder accountId(String var1);

        public Builder graphArn(String var1);

        public Builder delegationTime(Instant var1);
    }
}

