/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.IndicatorDetail;
import software.amazon.awssdk.services.detective.model.IndicatorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Indicator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Indicator> {
    private static final SdkField<String> INDICATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndicatorType").getter(Indicator.getter(Indicator::indicatorTypeAsString)).setter(Indicator.setter(Builder::indicatorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorType").build()}).build();
    private static final SdkField<IndicatorDetail> INDICATOR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndicatorDetail").getter(Indicator.getter(Indicator::indicatorDetail)).setter(Indicator.setter(Builder::indicatorDetail)).constructor(IndicatorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDICATOR_TYPE_FIELD, INDICATOR_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indicatorType;
    private final IndicatorDetail indicatorDetail;

    private Indicator(BuilderImpl builder) {
        this.indicatorType = builder.indicatorType;
        this.indicatorDetail = builder.indicatorDetail;
    }

    public final IndicatorType indicatorType() {
        return IndicatorType.fromValue(this.indicatorType);
    }

    public final String indicatorTypeAsString() {
        return this.indicatorType;
    }

    public final IndicatorDetail indicatorDetail() {
        return this.indicatorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indicatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indicatorDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Indicator)) {
            return false;
        }
        Indicator other = (Indicator)obj;
        return Objects.equals(this.indicatorTypeAsString(), other.indicatorTypeAsString()) && Objects.equals(this.indicatorDetail(), other.indicatorDetail());
    }

    public final String toString() {
        return ToString.builder((String)"Indicator").add("IndicatorType", (Object)this.indicatorTypeAsString()).add("IndicatorDetail", (Object)this.indicatorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndicatorType": {
                return Optional.ofNullable(clazz.cast(this.indicatorTypeAsString()));
            }
            case "IndicatorDetail": {
                return Optional.ofNullable(clazz.cast(this.indicatorDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Indicator, T> g) {
        return obj -> g.apply((Indicator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indicatorType;
        private IndicatorDetail indicatorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(Indicator model) {
            this.indicatorType(model.indicatorType);
            this.indicatorDetail(model.indicatorDetail);
        }

        public final String getIndicatorType() {
            return this.indicatorType;
        }

        public final void setIndicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
        }

        @Override
        public final Builder indicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
            return this;
        }

        @Override
        public final Builder indicatorType(IndicatorType indicatorType) {
            this.indicatorType(indicatorType == null ? null : indicatorType.toString());
            return this;
        }

        public final IndicatorDetail.Builder getIndicatorDetail() {
            return this.indicatorDetail != null ? this.indicatorDetail.toBuilder() : null;
        }

        public final void setIndicatorDetail(IndicatorDetail.BuilderImpl indicatorDetail) {
            this.indicatorDetail = indicatorDetail != null ? indicatorDetail.build() : null;
        }

        @Override
        public final Builder indicatorDetail(IndicatorDetail indicatorDetail) {
            this.indicatorDetail = indicatorDetail;
            return this;
        }

        public Indicator build() {
            return new Indicator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Indicator> {
        public Builder indicatorType(String var1);

        public Builder indicatorType(IndicatorType var1);

        public Builder indicatorDetail(IndicatorDetail var1);

        default public Builder indicatorDetail(Consumer<IndicatorDetail.Builder> indicatorDetail) {
            return this.indicatorDetail((IndicatorDetail)((IndicatorDetail.Builder)IndicatorDetail.builder().applyMutation(indicatorDetail)).build());
        }
    }
}

