/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.Reason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlaggedIpAddressDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlaggedIpAddressDetail> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(FlaggedIpAddressDetail.getter(FlaggedIpAddressDetail::ipAddress)).setter(FlaggedIpAddressDetail.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(FlaggedIpAddressDetail.getter(FlaggedIpAddressDetail::reasonAsString)).setter(FlaggedIpAddressDetail.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final String reason;

    private FlaggedIpAddressDetail(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.reason = builder.reason;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final Reason reason() {
        return Reason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlaggedIpAddressDetail)) {
            return false;
        }
        FlaggedIpAddressDetail other = (FlaggedIpAddressDetail)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlaggedIpAddressDetail").add("IpAddress", (Object)this.ipAddress()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlaggedIpAddressDetail, T> g) {
        return obj -> g.apply((FlaggedIpAddressDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(FlaggedIpAddressDetail model) {
            this.ipAddress(model.ipAddress);
            this.reason(model.reason);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(Reason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public FlaggedIpAddressDetail build() {
            return new FlaggedIpAddressDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlaggedIpAddressDetail> {
        public Builder ipAddress(String var1);

        public Builder reason(String var1);

        public Builder reason(Reason var1);
    }
}

