/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartInvestigationRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, StartInvestigationRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(StartInvestigationRequest.getter(StartInvestigationRequest::graphArn)).setter(StartInvestigationRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(StartInvestigationRequest.getter(StartInvestigationRequest::entityArn)).setter(StartInvestigationRequest.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<Instant> SCOPE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScopeStartTime").getter(StartInvestigationRequest.getter(StartInvestigationRequest::scopeStartTime)).setter(StartInvestigationRequest.setter(Builder::scopeStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SCOPE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScopeEndTime").getter(StartInvestigationRequest.getter(StartInvestigationRequest::scopeEndTime)).setter(StartInvestigationRequest.setter(Builder::scopeEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, ENTITY_ARN_FIELD, SCOPE_START_TIME_FIELD, SCOPE_END_TIME_FIELD));
    private final String graphArn;
    private final String entityArn;
    private final Instant scopeStartTime;
    private final Instant scopeEndTime;

    private StartInvestigationRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.entityArn = builder.entityArn;
        this.scopeStartTime = builder.scopeStartTime;
        this.scopeEndTime = builder.scopeEndTime;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    public final Instant scopeStartTime() {
        return this.scopeStartTime;
    }

    public final Instant scopeEndTime() {
        return this.scopeEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInvestigationRequest)) {
            return false;
        }
        StartInvestigationRequest other = (StartInvestigationRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.scopeStartTime(), other.scopeStartTime()) && Objects.equals(this.scopeEndTime(), other.scopeEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartInvestigationRequest").add("GraphArn", (Object)this.graphArn()).add("EntityArn", (Object)this.entityArn()).add("ScopeStartTime", (Object)this.scopeStartTime()).add("ScopeEndTime", (Object)this.scopeEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "ScopeStartTime": {
                return Optional.ofNullable(clazz.cast(this.scopeStartTime()));
            }
            case "ScopeEndTime": {
                return Optional.ofNullable(clazz.cast(this.scopeEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInvestigationRequest, T> g) {
        return obj -> g.apply((StartInvestigationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private String entityArn;
        private Instant scopeStartTime;
        private Instant scopeEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInvestigationRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.entityArn(model.entityArn);
            this.scopeStartTime(model.scopeStartTime);
            this.scopeEndTime(model.scopeEndTime);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final Instant getScopeStartTime() {
            return this.scopeStartTime;
        }

        public final void setScopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
        }

        @Override
        public final Builder scopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
            return this;
        }

        public final Instant getScopeEndTime() {
            return this.scopeEndTime;
        }

        public final void setScopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
        }

        @Override
        public final Builder scopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartInvestigationRequest build() {
            return new StartInvestigationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartInvestigationRequest> {
        public Builder graphArn(String var1);

        public Builder entityArn(String var1);

        public Builder scopeStartTime(Instant var1);

        public Builder scopeEndTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

