/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.detective.DetectiveClient;
import software.amazon.awssdk.services.detective.DetectiveServiceClientConfiguration;
import software.amazon.awssdk.services.detective.internal.DetectiveServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.detective.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.detective.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.detective.model.AccessDeniedException;
import software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest;
import software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse;
import software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest;
import software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse;
import software.amazon.awssdk.services.detective.model.ConflictException;
import software.amazon.awssdk.services.detective.model.CreateGraphRequest;
import software.amazon.awssdk.services.detective.model.CreateGraphResponse;
import software.amazon.awssdk.services.detective.model.CreateMembersRequest;
import software.amazon.awssdk.services.detective.model.CreateMembersResponse;
import software.amazon.awssdk.services.detective.model.DeleteGraphRequest;
import software.amazon.awssdk.services.detective.model.DeleteGraphResponse;
import software.amazon.awssdk.services.detective.model.DeleteMembersRequest;
import software.amazon.awssdk.services.detective.model.DeleteMembersResponse;
import software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.detective.model.DetectiveException;
import software.amazon.awssdk.services.detective.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.detective.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.detective.model.DisassociateMembershipRequest;
import software.amazon.awssdk.services.detective.model.DisassociateMembershipResponse;
import software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.detective.model.GetMembersRequest;
import software.amazon.awssdk.services.detective.model.GetMembersResponse;
import software.amazon.awssdk.services.detective.model.InternalServerException;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse;
import software.amazon.awssdk.services.detective.model.ListGraphsRequest;
import software.amazon.awssdk.services.detective.model.ListGraphsResponse;
import software.amazon.awssdk.services.detective.model.ListInvitationsRequest;
import software.amazon.awssdk.services.detective.model.ListInvitationsResponse;
import software.amazon.awssdk.services.detective.model.ListMembersRequest;
import software.amazon.awssdk.services.detective.model.ListMembersResponse;
import software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.detective.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.detective.model.RejectInvitationRequest;
import software.amazon.awssdk.services.detective.model.RejectInvitationResponse;
import software.amazon.awssdk.services.detective.model.ResourceNotFoundException;
import software.amazon.awssdk.services.detective.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest;
import software.amazon.awssdk.services.detective.model.StartMonitoringMemberResponse;
import software.amazon.awssdk.services.detective.model.TagResourceRequest;
import software.amazon.awssdk.services.detective.model.TagResourceResponse;
import software.amazon.awssdk.services.detective.model.TooManyRequestsException;
import software.amazon.awssdk.services.detective.model.UntagResourceRequest;
import software.amazon.awssdk.services.detective.model.UntagResourceResponse;
import software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest;
import software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesResponse;
import software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.detective.model.ValidationException;
import software.amazon.awssdk.services.detective.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.BatchGetGraphMemberDatasourcesRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.BatchGetMembershipDatasourcesRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.CreateGraphRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.DeleteGraphRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.DisableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.DisassociateMembershipRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.EnableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListDatasourcePackagesRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListGraphsRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListOrganizationAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.RejectInvitationRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.StartMonitoringMemberRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.UpdateDatasourcePackagesRequestMarshaller;
import software.amazon.awssdk.services.detective.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDetectiveClient
implements DetectiveClient {
    private static final Logger log = Logger.loggerFor(DefaultDetectiveClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final DetectiveServiceClientConfiguration serviceClientConfiguration;

    protected DefaultDetectiveClient(DetectiveServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, acceptInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptInvitation");
            AcceptInvitationResponse acceptInvitationResponse = (AcceptInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$acceptInvitation$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetGraphMemberDatasourcesResponse batchGetGraphMemberDatasources(BatchGetGraphMemberDatasourcesRequest batchGetGraphMemberDatasourcesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetGraphMemberDatasourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetGraphMemberDatasourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, batchGetGraphMemberDatasourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetGraphMemberDatasources");
            BatchGetGraphMemberDatasourcesResponse batchGetGraphMemberDatasourcesResponse = (BatchGetGraphMemberDatasourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetGraphMemberDatasources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetGraphMemberDatasourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetGraphMemberDatasourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetGraphMemberDatasourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$batchGetGraphMemberDatasources$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetMembershipDatasourcesResponse batchGetMembershipDatasources(BatchGetMembershipDatasourcesRequest batchGetMembershipDatasourcesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetMembershipDatasourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetMembershipDatasourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, batchGetMembershipDatasourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetMembershipDatasources");
            BatchGetMembershipDatasourcesResponse batchGetMembershipDatasourcesResponse = (BatchGetMembershipDatasourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetMembershipDatasources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetMembershipDatasourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetMembershipDatasourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetMembershipDatasourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$batchGetMembershipDatasources$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphResponse createGraph(CreateGraphRequest createGraphRequest) throws AccessDeniedException, ConflictException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, createGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraph");
            CreateGraphResponse createGraphResponse = (CreateGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$createGraph$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, createMembersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMembers");
            CreateMembersResponse createMembersResponse = (CreateMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMembers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMembersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMembersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$createMembers$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGraphResponse deleteGraph(DeleteGraphRequest deleteGraphRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, deleteGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGraph");
            DeleteGraphResponse deleteGraphResponse = (DeleteGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$deleteGraph$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, deleteMembersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMembers");
            DeleteMembersResponse deleteMembersResponse = (DeleteMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMembers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMembersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMembersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$deleteMembers$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfiguration");
            DescribeOrganizationConfigurationResponse describeOrganizationConfigurationResponse = (DescribeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$describeOrganizationConfiguration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableOrganizationAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableOrganizationAdminAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, disableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableOrganizationAdminAccount");
            DisableOrganizationAdminAccountResponse disableOrganizationAdminAccountResponse = (DisableOrganizationAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableOrganizationAdminAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableOrganizationAdminAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableOrganizationAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableOrganizationAdminAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$disableOrganizationAdminAccount$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMembershipResponse disassociateMembership(DisassociateMembershipRequest disassociateMembershipRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMembershipResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, disassociateMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMembership");
            DisassociateMembershipResponse disassociateMembershipResponse = (DisassociateMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMembership").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateMembershipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMembershipResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$disassociateMembership$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableOrganizationAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableOrganizationAdminAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, enableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableOrganizationAdminAccount");
            EnableOrganizationAdminAccountResponse enableOrganizationAdminAccountResponse = (EnableOrganizationAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableOrganizationAdminAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableOrganizationAdminAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableOrganizationAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableOrganizationAdminAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$enableOrganizationAdminAccount$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, getMembersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMembers");
            GetMembersResponse getMembersResponse = (GetMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMembers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMembersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMembersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$getMembers$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasourcePackagesResponse listDatasourcePackages(ListDatasourcePackagesRequest listDatasourcePackagesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasourcePackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasourcePackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listDatasourcePackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasourcePackages");
            ListDatasourcePackagesResponse listDatasourcePackagesResponse = (ListDatasourcePackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasourcePackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatasourcePackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasourcePackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasourcePackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listDatasourcePackages$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGraphsResponse listGraphs(ListGraphsRequest listGraphsRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGraphsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listGraphsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGraphs");
            ListGraphsResponse listGraphsResponse = (ListGraphsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGraphsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGraphsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGraphsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listGraphs$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInvitationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInvitations");
            ListInvitationsResponse listInvitationsResponse = (ListInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvitations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listInvitations$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listMembersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMembers");
            ListMembersResponse listMembersResponse = (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMembers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMembersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMembersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listMembers$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationAdminAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOrganizationAdminAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listOrganizationAdminAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationAdminAccounts");
            ListOrganizationAdminAccountsResponse listOrganizationAdminAccountsResponse = (ListOrganizationAdminAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationAdminAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOrganizationAdminAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationAdminAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationAdminAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listOrganizationAdminAccounts$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$listTagsForResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectInvitationResponse rejectInvitation(RejectInvitationRequest rejectInvitationRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectInvitationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, rejectInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectInvitation");
            RejectInvitationResponse rejectInvitationResponse = (RejectInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectInvitation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$rejectInvitation$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMonitoringMemberResponse startMonitoringMember(StartMonitoringMemberRequest startMonitoringMemberRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMonitoringMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMonitoringMemberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, startMonitoringMemberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMonitoringMember");
            StartMonitoringMemberResponse startMonitoringMemberResponse = (StartMonitoringMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMonitoringMember").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMonitoringMemberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMonitoringMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMonitoringMemberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$startMonitoringMember$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$tagResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$untagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatasourcePackagesResponse updateDatasourcePackages(UpdateDatasourcePackagesRequest updateDatasourcePackagesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatasourcePackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDatasourcePackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, updateDatasourcePackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatasourcePackages");
            UpdateDatasourcePackagesResponse updateDatasourcePackagesResponse = (UpdateDatasourcePackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatasourcePackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDatasourcePackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatasourcePackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatasourcePackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$updateDatasourcePackages$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, DetectiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateOrganizationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDetectiveClient.resolveMetricPublishers(clientConfiguration, updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Detective");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrganizationConfiguration");
            UpdateOrganizationConfigurationResponse updateOrganizationConfigurationResponse = (UpdateOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDetectiveClient.lambda$updateOrganizationConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "detective";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        DetectiveServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = DetectiveServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DetectiveException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    @Override
    public final DetectiveServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateOrganizationConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatasourcePackages$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMonitoringMember$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectInvitation$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationAdminAccounts$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMembers$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInvitations$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGraphs$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasourcePackages$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMembers$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableOrganizationAdminAccount$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateMembership$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableOrganizationAdminAccount$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationConfiguration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMembers$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGraph$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMembers$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGraph$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetMembershipDatasources$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetGraphMemberDatasources$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptInvitation$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

