/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class VolumeUsageByDatasourcePackageCopier {
    static Map<String, DatasourcePackageUsageInfo> copy(
            Map<String, ? extends DatasourcePackageUsageInfo> volumeUsageByDatasourcePackageParam) {
        Map<String, DatasourcePackageUsageInfo> map;
        if (volumeUsageByDatasourcePackageParam == null || volumeUsageByDatasourcePackageParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageUsageInfo> modifiableMap = new LinkedHashMap<>();
            volumeUsageByDatasourcePackageParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageUsageInfo> copyFromBuilder(
            Map<String, ? extends DatasourcePackageUsageInfo.Builder> volumeUsageByDatasourcePackageParam) {
        Map<String, DatasourcePackageUsageInfo> map;
        if (volumeUsageByDatasourcePackageParam == null || volumeUsageByDatasourcePackageParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageUsageInfo> modifiableMap = new LinkedHashMap<>();
            volumeUsageByDatasourcePackageParam.forEach((key, value) -> {
                DatasourcePackageUsageInfo member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageUsageInfo.Builder> copyToBuilder(
            Map<String, ? extends DatasourcePackageUsageInfo> volumeUsageByDatasourcePackageParam) {
        Map<String, DatasourcePackageUsageInfo.Builder> map;
        if (volumeUsageByDatasourcePackageParam == null || volumeUsageByDatasourcePackageParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageUsageInfo.Builder> modifiableMap = new LinkedHashMap<>();
            volumeUsageByDatasourcePackageParam.forEach((key, value) -> {
                DatasourcePackageUsageInfo.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageUsageInfo> copyEnumToString(
            Map<DatasourcePackage, ? extends DatasourcePackageUsageInfo> volumeUsageByDatasourcePackageParam) {
        Map<String, DatasourcePackageUsageInfo> map;
        if (volumeUsageByDatasourcePackageParam == null || volumeUsageByDatasourcePackageParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageUsageInfo> modifiableMap = new LinkedHashMap<>();
            volumeUsageByDatasourcePackageParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DatasourcePackage, DatasourcePackageUsageInfo> copyStringToEnum(
            Map<String, ? extends DatasourcePackageUsageInfo> volumeUsageByDatasourcePackageParam) {
        Map<DatasourcePackage, DatasourcePackageUsageInfo> map;
        if (volumeUsageByDatasourcePackageParam == null || volumeUsageByDatasourcePackageParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DatasourcePackage, DatasourcePackageUsageInfo> modifiableMap = new LinkedHashMap<>();
            volumeUsageByDatasourcePackageParam.forEach((key, value) -> {
                DatasourcePackage result = DatasourcePackage.fromValue(key);
                if (result != DatasourcePackage.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
