/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.detective.DefaultDetectiveBaseClientBuilder;
import software.amazon.awssdk.services.detective.DefaultDetectiveClient;
import software.amazon.awssdk.services.detective.DetectiveClient;
import software.amazon.awssdk.services.detective.DetectiveClientBuilder;
import software.amazon.awssdk.services.detective.DetectiveServiceClientConfiguration;
import software.amazon.awssdk.services.detective.endpoints.DetectiveEndpointProvider;

@SdkInternalApi
final class DefaultDetectiveClientBuilder
extends DefaultDetectiveBaseClientBuilder<DetectiveClientBuilder, DetectiveClient>
implements DetectiveClientBuilder {
    DefaultDetectiveClientBuilder() {
    }

    @Override
    public DefaultDetectiveClientBuilder endpointProvider(DetectiveEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DetectiveClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDetectiveClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DetectiveServiceClientConfiguration serviceClientConfiguration = DetectiveServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDetectiveClient(serviceClientConfiguration, clientConfiguration);
    }
}

