/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.detective.DefaultDetectiveAsyncClient;
import software.amazon.awssdk.services.detective.DefaultDetectiveBaseClientBuilder;
import software.amazon.awssdk.services.detective.DetectiveAsyncClient;
import software.amazon.awssdk.services.detective.DetectiveAsyncClientBuilder;
import software.amazon.awssdk.services.detective.DetectiveServiceClientConfiguration;
import software.amazon.awssdk.services.detective.endpoints.DetectiveEndpointProvider;

@SdkInternalApi
final class DefaultDetectiveAsyncClientBuilder
extends DefaultDetectiveBaseClientBuilder<DetectiveAsyncClientBuilder, DetectiveAsyncClient>
implements DetectiveAsyncClientBuilder {
    DefaultDetectiveAsyncClientBuilder() {
    }

    @Override
    public DefaultDetectiveAsyncClientBuilder endpointProvider(DetectiveEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DetectiveAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDetectiveAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DetectiveServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDetectiveAsyncClient client = new DefaultDetectiveAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DetectiveServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DetectiveServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

