/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasourcePackage {
    DETECTIVE_CORE("DETECTIVE_CORE"),
    EKS_AUDIT("EKS_AUDIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasourcePackage> VALUE_MAP;
    private final String value;

    private DatasourcePackage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasourcePackage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasourcePackage> knownValues() {
        EnumSet<DatasourcePackage> knownValues = EnumSet.allOf(DatasourcePackage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasourcePackage.class, DatasourcePackage::toString);
    }
}

