/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.MemberDetail;
import software.amazon.awssdk.services.detective.model.MemberDetailListCopier;
import software.amazon.awssdk.services.detective.model.UnprocessedAccount;
import software.amazon.awssdk.services.detective.model.UnprocessedAccountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembersResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, CreateMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(CreateMembersResponse.getter(CreateMembersResponse::members)).setter(CreateMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(CreateMembersResponse.getter(CreateMembersResponse::unprocessedAccounts)).setter(CreateMembersResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));
    private final List<MemberDetail> members;
    private final List<UnprocessedAccount> unprocessedAccounts;

    private CreateMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<MemberDetail> members() {
        return this.members;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersResponse)) {
            return false;
        }
        CreateMembersResponse other = (CreateMembersResponse)((Object)obj);
        return this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMembersResponse").add("Members", this.hasMembers() ? this.members() : null).add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersResponse, T> g) {
        return obj -> g.apply((CreateMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<MemberDetail> members = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersResponse model) {
            super(model);
            this.members(model.members);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<MemberDetail.Builder> getMembers() {
            if (this.members instanceof SdkAutoConstructList) {
                return null;
            }
            return this.members != null ? (Collection)this.members.stream().map(MemberDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<MemberDetail> members) {
            this.members = MemberDetailListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(MemberDetail ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<MemberDetail.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (MemberDetail)((MemberDetail.Builder)MemberDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<MemberDetail.BuilderImpl> members) {
            this.members = MemberDetailListCopier.copyFromBuilder(members);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            if (this.unprocessedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unprocessedAccounts != null ? (Collection)this.unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (UnprocessedAccount)((UnprocessedAccount.Builder)UnprocessedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public CreateMembersResponse build() {
            return new CreateMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembersResponse> {
        public Builder members(Collection<MemberDetail> var1);

        public Builder members(MemberDetail ... var1);

        public Builder members(Consumer<MemberDetail.Builder> ... var1);

        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);

        public Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... var1);
    }
}

