/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.ExceptionContextCopier;
import software.amazon.awssdk.services.deadline.model.ValidationExceptionField;
import software.amazon.awssdk.services.deadline.model.ValidationExceptionFieldListCopier;
import software.amazon.awssdk.services.deadline.model.ValidationExceptionReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationException
extends DeadlineException
implements ToCopyableBuilder<Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ValidationException.getter(ValidationException::reasonAsString)).setter(ValidationException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<ValidationExceptionField>> FIELD_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldList").getter(ValidationException.getter(ValidationException::fieldList)).setter(ValidationException.setter(Builder::fieldList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationExceptionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("context").getter(ValidationException.getter(ValidationException::context)).setter(ValidationException.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, FIELD_LIST_FIELD, CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final List<ValidationExceptionField> fieldList;
    private final Map<String, String> context;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.fieldList = builder.fieldList;
        this.context = builder.context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public boolean hasFieldList() {
        return this.fieldList != null && !(this.fieldList instanceof SdkAutoConstructList);
    }

    public List<ValidationExceptionField> fieldList() {
        return this.fieldList;
    }

    public boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public Map<String, String> context() {
        return this.context;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reason", REASON_FIELD);
        map.put("fieldList", FIELD_LIST_FIELD);
        map.put("context", CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineException.BuilderImpl
    implements Builder {
        private String reason;
        private List<ValidationExceptionField> fieldList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            this.reason(model.reason);
            this.fieldList(model.fieldList);
            this.context(model.context);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFieldList() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fieldList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldList(Collection<ValidationExceptionField.BuilderImpl> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copyFromBuilder(fieldList);
        }

        @Override
        public final Builder fieldList(Collection<ValidationExceptionField> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copy(fieldList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(ValidationExceptionField ... fieldList) {
            this.fieldList(Arrays.asList(fieldList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(Consumer<ValidationExceptionField.Builder> ... fieldList) {
            this.fieldList(Stream.of(fieldList).map(c -> (ValidationExceptionField)((ValidationExceptionField.Builder)ValidationExceptionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationException>,
    DeadlineException.Builder {
        public Builder reason(String var1);

        public Builder reason(ValidationExceptionReason var1);

        public Builder fieldList(Collection<ValidationExceptionField> var1);

        public Builder fieldList(ValidationExceptionField ... var1);

        public Builder fieldList(Consumer<ValidationExceptionField.Builder> ... var1);

        public Builder context(Map<String, String> var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

