/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummary;

public class ListStorageProfilesForQueueIterable
implements SdkIterable<ListStorageProfilesForQueueResponse> {
    private final DeadlineClient client;
    private final ListStorageProfilesForQueueRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageProfilesForQueueIterable(DeadlineClient client, ListStorageProfilesForQueueRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStorageProfilesForQueueResponseFetcher();
    }

    public Iterator<ListStorageProfilesForQueueResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StorageProfileSummary> storageProfiles() {
        Function<ListStorageProfilesForQueueResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageProfiles() != null) {
                return response.storageProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStorageProfilesForQueueResponseFetcher
    implements SyncPageFetcher<ListStorageProfilesForQueueResponse> {
        private ListStorageProfilesForQueueResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageProfilesForQueueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageProfilesForQueueResponse nextPage(ListStorageProfilesForQueueResponse previousPage) {
            if (previousPage == null) {
                return ListStorageProfilesForQueueIterable.this.client.listStorageProfilesForQueue(ListStorageProfilesForQueueIterable.this.firstRequest);
            }
            return ListStorageProfilesForQueueIterable.this.client.listStorageProfilesForQueue((ListStorageProfilesForQueueRequest)((Object)ListStorageProfilesForQueueIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

