/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AcceleratorCountRange;
import software.amazon.awssdk.services.deadline.model.AcceleratorSelection;
import software.amazon.awssdk.services.deadline.model.AcceleratorSelectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceleratorCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AcceleratorCapabilities> {
    private static final SdkField<List<AcceleratorSelection>> SELECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selections").getter(AcceleratorCapabilities.getter(AcceleratorCapabilities::selections)).setter(AcceleratorCapabilities.setter(Builder::selections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceleratorSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AcceleratorCountRange> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("count").getter(AcceleratorCapabilities.getter(AcceleratorCapabilities::count)).setter(AcceleratorCapabilities.setter(Builder::count)).constructor(AcceleratorCountRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTIONS_FIELD, COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceleratorCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AcceleratorSelection> selections;
    private final AcceleratorCountRange count;

    private AcceleratorCapabilities(BuilderImpl builder) {
        this.selections = builder.selections;
        this.count = builder.count;
    }

    public final boolean hasSelections() {
        return this.selections != null && !(this.selections instanceof SdkAutoConstructList);
    }

    public final List<AcceleratorSelection> selections() {
        return this.selections;
    }

    public final AcceleratorCountRange count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelections() ? this.selections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorCapabilities)) {
            return false;
        }
        AcceleratorCapabilities other = (AcceleratorCapabilities)obj;
        return this.hasSelections() == other.hasSelections() && Objects.equals(this.selections(), other.selections()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"AcceleratorCapabilities").add("Selections", this.hasSelections() ? this.selections() : null).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selections": {
                return Optional.ofNullable(clazz.cast(this.selections()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("selections", SELECTIONS_FIELD);
        map.put("count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorCapabilities, T> g) {
        return obj -> g.apply((AcceleratorCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AcceleratorSelection> selections = DefaultSdkAutoConstructList.getInstance();
        private AcceleratorCountRange count;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorCapabilities model) {
            this.selections(model.selections);
            this.count(model.count);
        }

        public final List<AcceleratorSelection.Builder> getSelections() {
            List<AcceleratorSelection.Builder> result = AcceleratorSelectionsCopier.copyToBuilder(this.selections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelections(Collection<AcceleratorSelection.BuilderImpl> selections) {
            this.selections = AcceleratorSelectionsCopier.copyFromBuilder(selections);
        }

        @Override
        public final Builder selections(Collection<AcceleratorSelection> selections) {
            this.selections = AcceleratorSelectionsCopier.copy(selections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selections(AcceleratorSelection ... selections) {
            this.selections(Arrays.asList(selections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selections(Consumer<AcceleratorSelection.Builder> ... selections) {
            this.selections(Stream.of(selections).map(c -> (AcceleratorSelection)((AcceleratorSelection.Builder)AcceleratorSelection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AcceleratorCountRange.Builder getCount() {
            return this.count != null ? this.count.toBuilder() : null;
        }

        public final void setCount(AcceleratorCountRange.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(AcceleratorCountRange count) {
            this.count = count;
            return this;
        }

        public AcceleratorCapabilities build() {
            return new AcceleratorCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AcceleratorCapabilities> {
        public Builder selections(Collection<AcceleratorSelection> var1);

        public Builder selections(AcceleratorSelection ... var1);

        public Builder selections(Consumer<AcceleratorSelection.Builder> ... var1);

        public Builder count(AcceleratorCountRange var1);

        default public Builder count(Consumer<AcceleratorCountRange.Builder> count) {
            return this.count((AcceleratorCountRange)((AcceleratorCountRange.Builder)AcceleratorCountRange.builder().applyMutation(count)).build());
        }
    }
}

