/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseEndpointSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseEndpointSummary> {
    private static final SdkField<String> LICENSE_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseEndpointId").getter(LicenseEndpointSummary.getter(LicenseEndpointSummary::licenseEndpointId)).setter(LicenseEndpointSummary.setter(Builder::licenseEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEndpointId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LicenseEndpointSummary.getter(LicenseEndpointSummary::statusAsString)).setter(LicenseEndpointSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(LicenseEndpointSummary.getter(LicenseEndpointSummary::statusMessage)).setter(LicenseEndpointSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(LicenseEndpointSummary.getter(LicenseEndpointSummary::vpcId)).setter(LicenseEndpointSummary.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ENDPOINT_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseEndpointSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String licenseEndpointId;
    private final String status;
    private final String statusMessage;
    private final String vpcId;

    private LicenseEndpointSummary(BuilderImpl builder) {
        this.licenseEndpointId = builder.licenseEndpointId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.vpcId = builder.vpcId;
    }

    public final String licenseEndpointId() {
        return this.licenseEndpointId;
    }

    public final LicenseEndpointStatus status() {
        return LicenseEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseEndpointSummary)) {
            return false;
        }
        LicenseEndpointSummary other = (LicenseEndpointSummary)obj;
        return Objects.equals(this.licenseEndpointId(), other.licenseEndpointId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseEndpointSummary").add("LicenseEndpointId", (Object)this.licenseEndpointId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "licenseEndpointId": {
                return Optional.ofNullable(clazz.cast(this.licenseEndpointId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("licenseEndpointId", LICENSE_ENDPOINT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseEndpointSummary, T> g) {
        return obj -> g.apply((LicenseEndpointSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String licenseEndpointId;
        private String status;
        private String statusMessage;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseEndpointSummary model) {
            this.licenseEndpointId(model.licenseEndpointId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.vpcId(model.vpcId);
        }

        public final String getLicenseEndpointId() {
            return this.licenseEndpointId;
        }

        public final void setLicenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
        }

        @Override
        public final Builder licenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public LicenseEndpointSummary build() {
            return new LicenseEndpointSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseEndpointSummary> {
        public Builder licenseEndpointId(String var1);

        public Builder status(String var1);

        public Builder status(LicenseEndpointStatus var1);

        public Builder statusMessage(String var1);

        public Builder vpcId(String var1);
    }
}

