/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummariesCopier;
import software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueueLimitAssociationsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListQueueLimitAssociationsResponse> {
    private static final SdkField<List<QueueLimitAssociationSummary>> QUEUE_LIMIT_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queueLimitAssociations").getter(ListQueueLimitAssociationsResponse.getter(ListQueueLimitAssociationsResponse::queueLimitAssociations)).setter(ListQueueLimitAssociationsResponse.setter(Builder::queueLimitAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueLimitAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueLimitAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQueueLimitAssociationsResponse.getter(ListQueueLimitAssociationsResponse::nextToken)).setter(ListQueueLimitAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_LIMIT_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueueLimitAssociationsResponse.memberNameToFieldInitializer();
    private final List<QueueLimitAssociationSummary> queueLimitAssociations;
    private final String nextToken;

    private ListQueueLimitAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.queueLimitAssociations = builder.queueLimitAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueueLimitAssociations() {
        return this.queueLimitAssociations != null && !(this.queueLimitAssociations instanceof SdkAutoConstructList);
    }

    public final List<QueueLimitAssociationSummary> queueLimitAssociations() {
        return this.queueLimitAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueLimitAssociations() ? this.queueLimitAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueLimitAssociationsResponse)) {
            return false;
        }
        ListQueueLimitAssociationsResponse other = (ListQueueLimitAssociationsResponse)((Object)obj);
        return this.hasQueueLimitAssociations() == other.hasQueueLimitAssociations() && Objects.equals(this.queueLimitAssociations(), other.queueLimitAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueueLimitAssociationsResponse").add("QueueLimitAssociations", this.hasQueueLimitAssociations() ? this.queueLimitAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueLimitAssociations": {
                return Optional.ofNullable(clazz.cast(this.queueLimitAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queueLimitAssociations", QUEUE_LIMIT_ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueueLimitAssociationsResponse, T> g) {
        return obj -> g.apply((ListQueueLimitAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<QueueLimitAssociationSummary> queueLimitAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueLimitAssociationsResponse model) {
            super(model);
            this.queueLimitAssociations(model.queueLimitAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<QueueLimitAssociationSummary.Builder> getQueueLimitAssociations() {
            List<QueueLimitAssociationSummary.Builder> result = QueueLimitAssociationSummariesCopier.copyToBuilder(this.queueLimitAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueLimitAssociations(Collection<QueueLimitAssociationSummary.BuilderImpl> queueLimitAssociations) {
            this.queueLimitAssociations = QueueLimitAssociationSummariesCopier.copyFromBuilder(queueLimitAssociations);
        }

        @Override
        public final Builder queueLimitAssociations(Collection<QueueLimitAssociationSummary> queueLimitAssociations) {
            this.queueLimitAssociations = QueueLimitAssociationSummariesCopier.copy(queueLimitAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueLimitAssociations(QueueLimitAssociationSummary ... queueLimitAssociations) {
            this.queueLimitAssociations(Arrays.asList(queueLimitAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueLimitAssociations(Consumer<QueueLimitAssociationSummary.Builder> ... queueLimitAssociations) {
            this.queueLimitAssociations(Stream.of(queueLimitAssociations).map(c -> (QueueLimitAssociationSummary)((QueueLimitAssociationSummary.Builder)QueueLimitAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueueLimitAssociationsResponse build() {
            return new ListQueueLimitAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueueLimitAssociationsResponse> {
        public Builder queueLimitAssociations(Collection<QueueLimitAssociationSummary> var1);

        public Builder queueLimitAssociations(QueueLimitAssociationSummary ... var1);

        public Builder queueLimitAssociations(Consumer<QueueLimitAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

