/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.Attachments;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.JobLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.JobParameter;
import software.amazon.awssdk.services.deadline.model.JobParametersCopier;
import software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatusCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetJobResponse.getter(GetJobResponse::jobId)).setter(GetJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetJobResponse.getter(GetJobResponse::name)).setter(GetJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(GetJobResponse.getter(GetJobResponse::lifecycleStatusAsString)).setter(GetJobResponse.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatusMessage").getter(GetJobResponse.getter(GetJobResponse::lifecycleStatusMessage)).setter(GetJobResponse.setter(Builder::lifecycleStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(GetJobResponse.getter(GetJobResponse::priority)).setter(GetJobResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetJobResponse.getter(GetJobResponse::createdAt)).setter(GetJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetJobResponse.getter(GetJobResponse::createdBy)).setter(GetJobResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetJobResponse.getter(GetJobResponse::updatedAt)).setter(GetJobResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetJobResponse.getter(GetJobResponse::updatedBy)).setter(GetJobResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetJobResponse.getter(GetJobResponse::startedAt)).setter(GetJobResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetJobResponse.getter(GetJobResponse::endedAt)).setter(GetJobResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRunStatus").getter(GetJobResponse.getter(GetJobResponse::taskRunStatusAsString)).setter(GetJobResponse.setter(Builder::taskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(GetJobResponse.getter(GetJobResponse::targetTaskRunStatusAsString)).setter(GetJobResponse.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskRunStatusCounts").getter(GetJobResponse.getter(GetJobResponse::taskRunStatusCountsAsStrings)).setter(GetJobResponse.setter(Builder::taskRunStatusCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageProfileId").getter(GetJobResponse.getter(GetJobResponse::storageProfileId)).setter(GetJobResponse.setter(Builder::storageProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()}).build();
    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailedTasksCount").getter(GetJobResponse.getter(GetJobResponse::maxFailedTasksCount)).setter(GetJobResponse.setter(Builder::maxFailedTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRetriesPerTask").getter(GetJobResponse.getter(GetJobResponse::maxRetriesPerTask)).setter(GetJobResponse.setter(Builder::maxRetriesPerTask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()}).build();
    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(GetJobResponse.getter(GetJobResponse::parameters)).setter(GetJobResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Attachments> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attachments").getter(GetJobResponse.getter(GetJobResponse::attachments)).setter(GetJobResponse.setter(Builder::attachments)).constructor(Attachments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetJobResponse.getter(GetJobResponse::description)).setter(GetJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SOURCE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceJobId").getter(GetJobResponse.getter(GetJobResponse::sourceJobId)).setter(GetJobResponse.setter(Builder::sourceJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, NAME_FIELD, LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, PRIORITY_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, TASK_RUN_STATUS_FIELD, TARGET_TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, STORAGE_PROFILE_ID_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, PARAMETERS_FIELD, ATTACHMENTS_FIELD, DESCRIPTION_FIELD, SOURCE_JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobId", JOB_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
            this.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
            this.put("priority", PRIORITY_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
            this.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
            this.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
            this.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
            this.put("maxFailedTasksCount", MAX_FAILED_TASKS_COUNT_FIELD);
            this.put("maxRetriesPerTask", MAX_RETRIES_PER_TASK_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("attachments", ATTACHMENTS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("sourceJobId", SOURCE_JOB_ID_FIELD);
        }
    });
    private final String jobId;
    private final String name;
    private final String lifecycleStatus;
    private final String lifecycleStatusMessage;
    private final Integer priority;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final Instant startedAt;
    private final Instant endedAt;
    private final String taskRunStatus;
    private final String targetTaskRunStatus;
    private final Map<String, Integer> taskRunStatusCounts;
    private final String storageProfileId;
    private final Integer maxFailedTasksCount;
    private final Integer maxRetriesPerTask;
    private final Map<String, JobParameter> parameters;
    private final Attachments attachments;
    private final String description;
    private final String sourceJobId;

    private GetJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.priority = builder.priority;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.taskRunStatus = builder.taskRunStatus;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.storageProfileId = builder.storageProfileId;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.parameters = builder.parameters;
        this.attachments = builder.attachments;
        this.description = builder.description;
        this.sourceJobId = builder.sourceJobId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String name() {
        return this.name;
    }

    public final JobLifecycleStatus lifecycleStatus() {
        return JobLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final String lifecycleStatusMessage() {
        return this.lifecycleStatusMessage;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(this.taskRunStatus);
    }

    public final String taskRunStatusAsString() {
        return this.taskRunStatus;
    }

    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(this.taskRunStatusCounts);
    }

    public final boolean hasTaskRunStatusCounts() {
        return this.taskRunStatusCounts != null && !(this.taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return this.taskRunStatusCounts;
    }

    public final String storageProfileId() {
        return this.storageProfileId;
    }

    public final Integer maxFailedTasksCount() {
        return this.maxFailedTasksCount;
    }

    public final Integer maxRetriesPerTask() {
        return this.maxRetriesPerTask;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, JobParameter> parameters() {
        return this.parameters;
    }

    public final Attachments attachments() {
        return this.attachments;
    }

    public final String description() {
        return this.description;
    }

    public final String sourceJobId() {
        return this.sourceJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.lifecycleStatusMessage(), other.lifecycleStatusMessage()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.taskRunStatusAsString(), other.taskRunStatusAsString()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && this.hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts() && Objects.equals(this.taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings()) && Objects.equals(this.storageProfileId(), other.storageProfileId()) && Objects.equals(this.maxFailedTasksCount(), other.maxFailedTasksCount()) && Objects.equals(this.maxRetriesPerTask(), other.maxRetriesPerTask()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceJobId(), other.sourceJobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobResponse").add("JobId", (Object)this.jobId()).add("Name", (Object)this.name()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("LifecycleStatusMessage", (Object)this.lifecycleStatusMessage()).add("Priority", (Object)this.priority()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("TaskRunStatus", (Object)this.taskRunStatusAsString()).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("TaskRunStatusCounts", this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null).add("StorageProfileId", (Object)this.storageProfileId()).add("MaxFailedTasksCount", (Object)this.maxFailedTasksCount()).add("MaxRetriesPerTask", (Object)this.maxRetriesPerTask()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Attachments", (Object)this.attachments()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceJobId", (Object)this.sourceJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "lifecycleStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusMessage()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "taskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusAsString()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "taskRunStatusCounts": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusCountsAsStrings()));
            }
            case "storageProfileId": {
                return Optional.ofNullable(clazz.cast(this.storageProfileId()));
            }
            case "maxFailedTasksCount": {
                return Optional.ofNullable(clazz.cast(this.maxFailedTasksCount()));
            }
            case "maxRetriesPerTask": {
                return Optional.ofNullable(clazz.cast(this.maxRetriesPerTask()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sourceJobId": {
                return Optional.ofNullable(clazz.cast(this.sourceJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetJobResponse, T> g) {
        return obj -> g.apply((GetJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String name;
        private String lifecycleStatus;
        private String lifecycleStatusMessage;
        private Integer priority;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private Instant startedAt;
        private Instant endedAt;
        private String taskRunStatus;
        private String targetTaskRunStatus;
        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();
        private String storageProfileId;
        private Integer maxFailedTasksCount;
        private Integer maxRetriesPerTask;
        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Attachments attachments;
        private String description;
        private String sourceJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.name(model.name);
            this.lifecycleStatus(model.lifecycleStatus);
            this.lifecycleStatusMessage(model.lifecycleStatusMessage);
            this.priority(model.priority);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.taskRunStatus(model.taskRunStatus);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            this.storageProfileId(model.storageProfileId);
            this.maxFailedTasksCount(model.maxFailedTasksCount);
            this.maxRetriesPerTask(model.maxRetriesPerTask);
            this.parameters(model.parameters);
            this.attachments(model.attachments);
            this.description(model.description);
            this.sourceJobId(model.sourceJobId);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return this.lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getTaskRunStatus() {
            return this.taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (this.taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final String getStorageProfileId() {
            return this.storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return this.maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return this.maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final Attachments.Builder getAttachments() {
            return this.attachments != null ? this.attachments.toBuilder() : null;
        }

        public final void setAttachments(Attachments.BuilderImpl attachments) {
            this.attachments = attachments != null ? attachments.build() : null;
        }

        @Override
        public final Builder attachments(Attachments attachments) {
            this.attachments = attachments;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSourceJobId() {
            return this.sourceJobId;
        }

        public final void setSourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
        }

        @Override
        public final Builder sourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
            return this;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobResponse> {
        public Builder jobId(String var1);

        public Builder name(String var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(JobLifecycleStatus var1);

        public Builder lifecycleStatusMessage(String var1);

        public Builder priority(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder taskRunStatus(String var1);

        public Builder taskRunStatus(TaskRunStatus var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(JobTargetTaskRunStatus var1);

        public Builder taskRunStatusCountsWithStrings(Map<String, Integer> var1);

        public Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> var1);

        public Builder storageProfileId(String var1);

        public Builder maxFailedTasksCount(Integer var1);

        public Builder maxRetriesPerTask(Integer var1);

        public Builder parameters(Map<String, JobParameter> var1);

        public Builder attachments(Attachments var1);

        default public Builder attachments(Consumer<Attachments.Builder> attachments) {
            return this.attachments((Attachments)((Attachments.Builder)Attachments.builder().applyMutation(attachments)).build());
        }

        public Builder description(String var1);

        public Builder sourceJobId(String var1);
    }
}

