/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.TaskSearchSummariesCopier;
import software.amazon.awssdk.services.deadline.model.TaskSearchSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTasksResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, SearchTasksResponse> {
    private static final SdkField<List<TaskSearchSummary>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(SearchTasksResponse.getter(SearchTasksResponse::tasks)).setter(SearchTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nextItemOffset").getter(SearchTasksResponse.getter(SearchTasksResponse::nextItemOffset)).setter(SearchTasksResponse.setter(Builder::nextItemOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()}).build();
    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResults").getter(SearchTasksResponse.getter(SearchTasksResponse::totalResults)).setter(SearchTasksResponse.setter(Builder::totalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_ITEM_OFFSET_FIELD, TOTAL_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tasks", TASKS_FIELD);
            this.put("nextItemOffset", NEXT_ITEM_OFFSET_FIELD);
            this.put("totalResults", TOTAL_RESULTS_FIELD);
        }
    });
    private final List<TaskSearchSummary> tasks;
    private final Integer nextItemOffset;
    private final Integer totalResults;

    private SearchTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextItemOffset = builder.nextItemOffset;
        this.totalResults = builder.totalResults;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<TaskSearchSummary> tasks() {
        return this.tasks;
    }

    public final Integer nextItemOffset() {
        return this.nextItemOffset;
    }

    public final Integer totalResults() {
        return this.totalResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTasksResponse)) {
            return false;
        }
        SearchTasksResponse other = (SearchTasksResponse)((Object)obj);
        return this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextItemOffset(), other.nextItemOffset()) && Objects.equals(this.totalResults(), other.totalResults());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTasksResponse").add("Tasks", this.hasTasks() ? this.tasks() : null).add("NextItemOffset", (Object)this.nextItemOffset()).add("TotalResults", (Object)this.totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "nextItemOffset": {
                return Optional.ofNullable(clazz.cast(this.nextItemOffset()));
            }
            case "totalResults": {
                return Optional.ofNullable(clazz.cast(this.totalResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTasksResponse, T> g) {
        return obj -> g.apply((SearchTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<TaskSearchSummary> tasks = DefaultSdkAutoConstructList.getInstance();
        private Integer nextItemOffset;
        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextItemOffset(model.nextItemOffset);
            this.totalResults(model.totalResults);
        }

        public final List<TaskSearchSummary.Builder> getTasks() {
            List<TaskSearchSummary.Builder> result = TaskSearchSummariesCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<TaskSearchSummary.BuilderImpl> tasks) {
            this.tasks = TaskSearchSummariesCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<TaskSearchSummary> tasks) {
            this.tasks = TaskSearchSummariesCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(TaskSearchSummary ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<TaskSearchSummary.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (TaskSearchSummary)((TaskSearchSummary.Builder)TaskSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNextItemOffset() {
            return this.nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final Integer getTotalResults() {
            return this.totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchTasksResponse build() {
            return new SearchTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTasksResponse> {
        public Builder tasks(Collection<TaskSearchSummary> var1);

        public Builder tasks(TaskSearchSummary ... var1);

        public Builder tasks(Consumer<TaskSearchSummary.Builder> ... var1);

        public Builder nextItemOffset(Integer var1);

        public Builder totalResults(Integer var1);
    }
}

