/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyJobTemplateRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, CopyJobTemplateRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(CopyJobTemplateRequest.getter(CopyJobTemplateRequest::farmId)).setter(CopyJobTemplateRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(CopyJobTemplateRequest.getter(CopyJobTemplateRequest::jobId)).setter(CopyJobTemplateRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(CopyJobTemplateRequest.getter(CopyJobTemplateRequest::queueId)).setter(CopyJobTemplateRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<S3Location> TARGET_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetS3Location").getter(CopyJobTemplateRequest.getter(CopyJobTemplateRequest::targetS3Location)).setter(CopyJobTemplateRequest.setter(Builder::targetS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetS3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, JOB_ID_FIELD, QUEUE_ID_FIELD, TARGET_S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("farmId", FARM_ID_FIELD);
            this.put("jobId", JOB_ID_FIELD);
            this.put("queueId", QUEUE_ID_FIELD);
            this.put("targetS3Location", TARGET_S3_LOCATION_FIELD);
        }
    });
    private final String farmId;
    private final String jobId;
    private final String queueId;
    private final S3Location targetS3Location;

    private CopyJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.targetS3Location = builder.targetS3Location;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final S3Location targetS3Location() {
        return this.targetS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetS3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJobTemplateRequest)) {
            return false;
        }
        CopyJobTemplateRequest other = (CopyJobTemplateRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.targetS3Location(), other.targetS3Location());
    }

    public final String toString() {
        return ToString.builder((String)"CopyJobTemplateRequest").add("FarmId", (Object)this.farmId()).add("JobId", (Object)this.jobId()).add("QueueId", (Object)this.queueId()).add("TargetS3Location", (Object)this.targetS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "targetS3Location": {
                return Optional.ofNullable(clazz.cast(this.targetS3Location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyJobTemplateRequest, T> g) {
        return obj -> g.apply((CopyJobTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String jobId;
        private String queueId;
        private S3Location targetS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJobTemplateRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.jobId(model.jobId);
            this.queueId(model.queueId);
            this.targetS3Location(model.targetS3Location);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final S3Location.Builder getTargetS3Location() {
            return this.targetS3Location != null ? this.targetS3Location.toBuilder() : null;
        }

        public final void setTargetS3Location(S3Location.BuilderImpl targetS3Location) {
            this.targetS3Location = targetS3Location != null ? targetS3Location.build() : null;
        }

        @Override
        public final Builder targetS3Location(S3Location targetS3Location) {
            this.targetS3Location = targetS3Location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyJobTemplateRequest build() {
            return new CopyJobTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyJobTemplateRequest> {
        public Builder farmId(String var1);

        public Builder jobId(String var1);

        public Builder queueId(String var1);

        public Builder targetS3Location(S3Location var1);

        default public Builder targetS3Location(Consumer<S3Location.Builder> targetS3Location) {
            return this.targetS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(targetS3Location)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

