/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.PosixUser;
import software.amazon.awssdk.services.deadline.model.RunAs;
import software.amazon.awssdk.services.deadline.model.WindowsUser;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRunAsUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRunAsUser> {
    private static final SdkField<PosixUser> POSIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("posix").getter(JobRunAsUser.getter(JobRunAsUser::posix)).setter(JobRunAsUser.setter(Builder::posix)).constructor(PosixUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("posix").build()}).build();
    private static final SdkField<WindowsUser> WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("windows").getter(JobRunAsUser.getter(JobRunAsUser::windows)).setter(JobRunAsUser.setter(Builder::windows)).constructor(WindowsUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windows").build()}).build();
    private static final SdkField<String> RUN_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runAs").getter(JobRunAsUser.getter(JobRunAsUser::runAsAsString)).setter(JobRunAsUser.setter(Builder::runAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSIX_FIELD, WINDOWS_FIELD, RUN_AS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("posix", POSIX_FIELD);
            this.put("windows", WINDOWS_FIELD);
            this.put("runAs", RUN_AS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PosixUser posix;
    private final WindowsUser windows;
    private final String runAs;

    private JobRunAsUser(BuilderImpl builder) {
        this.posix = builder.posix;
        this.windows = builder.windows;
        this.runAs = builder.runAs;
    }

    public final PosixUser posix() {
        return this.posix;
    }

    public final WindowsUser windows() {
        return this.windows;
    }

    public final RunAs runAs() {
        return RunAs.fromValue(this.runAs);
    }

    public final String runAsAsString() {
        return this.runAs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.posix());
        hashCode = 31 * hashCode + Objects.hashCode(this.windows());
        hashCode = 31 * hashCode + Objects.hashCode(this.runAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunAsUser)) {
            return false;
        }
        JobRunAsUser other = (JobRunAsUser)obj;
        return Objects.equals(this.posix(), other.posix()) && Objects.equals(this.windows(), other.windows()) && Objects.equals(this.runAsAsString(), other.runAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobRunAsUser").add("Posix", (Object)this.posix()).add("Windows", (Object)this.windows()).add("RunAs", (Object)this.runAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "posix": {
                return Optional.ofNullable(clazz.cast(this.posix()));
            }
            case "windows": {
                return Optional.ofNullable(clazz.cast(this.windows()));
            }
            case "runAs": {
                return Optional.ofNullable(clazz.cast(this.runAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobRunAsUser, T> g) {
        return obj -> g.apply((JobRunAsUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PosixUser posix;
        private WindowsUser windows;
        private String runAs;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunAsUser model) {
            this.posix(model.posix);
            this.windows(model.windows);
            this.runAs(model.runAs);
        }

        public final PosixUser.Builder getPosix() {
            return this.posix != null ? this.posix.toBuilder() : null;
        }

        public final void setPosix(PosixUser.BuilderImpl posix) {
            this.posix = posix != null ? posix.build() : null;
        }

        @Override
        public final Builder posix(PosixUser posix) {
            this.posix = posix;
            return this;
        }

        public final WindowsUser.Builder getWindows() {
            return this.windows != null ? this.windows.toBuilder() : null;
        }

        public final void setWindows(WindowsUser.BuilderImpl windows) {
            this.windows = windows != null ? windows.build() : null;
        }

        @Override
        public final Builder windows(WindowsUser windows) {
            this.windows = windows;
            return this;
        }

        public final String getRunAs() {
            return this.runAs;
        }

        public final void setRunAs(String runAs) {
            this.runAs = runAs;
        }

        @Override
        public final Builder runAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        @Override
        public final Builder runAs(RunAs runAs) {
            this.runAs(runAs == null ? null : runAs.toString());
            return this;
        }

        public JobRunAsUser build() {
            return new JobRunAsUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRunAsUser> {
        public Builder posix(PosixUser var1);

        default public Builder posix(Consumer<PosixUser.Builder> posix) {
            return this.posix((PosixUser)((PosixUser.Builder)PosixUser.builder().applyMutation(posix)).build());
        }

        public Builder windows(WindowsUser var1);

        default public Builder windows(Consumer<WindowsUser.Builder> windows) {
            return this.windows((WindowsUser)((WindowsUser.Builder)WindowsUser.builder().applyMutation(windows)).build());
        }

        public Builder runAs(String var1);

        public Builder runAs(RunAs var1);
    }
}

