/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.MembershipLevel;
import software.amazon.awssdk.services.deadline.model.PrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueMember> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(QueueMember.getter(QueueMember::farmId)).setter(QueueMember.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(QueueMember.getter(QueueMember::queueId)).setter(QueueMember.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(QueueMember.getter(QueueMember::principalId)).setter(QueueMember.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalType").getter(QueueMember.getter(QueueMember::principalTypeAsString)).setter(QueueMember.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityStoreId").getter(QueueMember.getter(QueueMember::identityStoreId)).setter(QueueMember.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipLevel").getter(QueueMember.getter(QueueMember::membershipLevelAsString)).setter(QueueMember.setter(Builder::membershipLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, QUEUE_ID_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, IDENTITY_STORE_ID_FIELD, MEMBERSHIP_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String farmId;
    private final String queueId;
    private final String principalId;
    private final String principalType;
    private final String identityStoreId;
    private final String membershipLevel;

    private QueueMember(BuilderImpl builder) {
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.identityStoreId = builder.identityStoreId;
        this.membershipLevel = builder.membershipLevel;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final MembershipLevel membershipLevel() {
        return MembershipLevel.fromValue(this.membershipLevel);
    }

    public final String membershipLevelAsString() {
        return this.membershipLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueMember)) {
            return false;
        }
        QueueMember other = (QueueMember)obj;
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.membershipLevelAsString(), other.membershipLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QueueMember").add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).add("IdentityStoreId", (Object)this.identityStoreId()).add("MembershipLevel", (Object)this.membershipLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "principalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "identityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "membershipLevel": {
                return Optional.ofNullable(clazz.cast(this.membershipLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueMember, T> g) {
        return obj -> g.apply((QueueMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String farmId;
        private String queueId;
        private String principalId;
        private String principalType;
        private String identityStoreId;
        private String membershipLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueMember model) {
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
            this.identityStoreId(model.identityStoreId);
            this.membershipLevel(model.membershipLevel);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipLevel() {
            return this.membershipLevel;
        }

        public final void setMembershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
        }

        @Override
        public final Builder membershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
            return this;
        }

        @Override
        public final Builder membershipLevel(MembershipLevel membershipLevel) {
            this.membershipLevel(membershipLevel == null ? null : membershipLevel.toString());
            return this;
        }

        public QueueMember build() {
            return new QueueMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueMember> {
        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder identityStoreId(String var1);

        public Builder membershipLevel(String var1);

        public Builder membershipLevel(MembershipLevel var1);
    }
}

