/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions;
import software.amazon.awssdk.services.deadline.model.SearchSortExpression;
import software.amazon.awssdk.services.deadline.model.SearchSortExpressionsCopier;
import software.amazon.awssdk.services.deadline.model.SearchWorkersRequestFleetIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchWorkersRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, SearchWorkersRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(SearchWorkersRequest.getter(SearchWorkersRequest::farmId)).setter(SearchWorkersRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleetIds").getter(SearchWorkersRequest.getter(SearchWorkersRequest::fleetIds)).setter(SearchWorkersRequest.setter(Builder::fleetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SearchGroupedFilterExpressions> FILTER_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterExpressions").getter(SearchWorkersRequest.getter(SearchWorkersRequest::filterExpressions)).setter(SearchWorkersRequest.setter(Builder::filterExpressions)).constructor(SearchGroupedFilterExpressions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpressions").build()}).build();
    private static final SdkField<List<SearchSortExpression>> SORT_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortExpressions").getter(SearchWorkersRequest.getter(SearchWorkersRequest::sortExpressions)).setter(SearchWorkersRequest.setter(Builder::sortExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSortExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> ITEM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("itemOffset").getter(SearchWorkersRequest.getter(SearchWorkersRequest::itemOffset)).setter(SearchWorkersRequest.setter(Builder::itemOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemOffset").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pageSize").getter(SearchWorkersRequest.getter(SearchWorkersRequest::pageSize)).setter(SearchWorkersRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_IDS_FIELD, FILTER_EXPRESSIONS_FIELD, SORT_EXPRESSIONS_FIELD, ITEM_OFFSET_FIELD, PAGE_SIZE_FIELD));
    private final String farmId;
    private final List<String> fleetIds;
    private final SearchGroupedFilterExpressions filterExpressions;
    private final List<SearchSortExpression> sortExpressions;
    private final Integer itemOffset;
    private final Integer pageSize;

    private SearchWorkersRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetIds = builder.fleetIds;
        this.filterExpressions = builder.filterExpressions;
        this.sortExpressions = builder.sortExpressions;
        this.itemOffset = builder.itemOffset;
        this.pageSize = builder.pageSize;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final boolean hasFleetIds() {
        return this.fleetIds != null && !(this.fleetIds instanceof SdkAutoConstructList);
    }

    public final List<String> fleetIds() {
        return this.fleetIds;
    }

    public final SearchGroupedFilterExpressions filterExpressions() {
        return this.filterExpressions;
    }

    public final boolean hasSortExpressions() {
        return this.sortExpressions != null && !(this.sortExpressions instanceof SdkAutoConstructList);
    }

    public final List<SearchSortExpression> sortExpressions() {
        return this.sortExpressions;
    }

    public final Integer itemOffset() {
        return this.itemOffset;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetIds() ? this.fleetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortExpressions() ? this.sortExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.itemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkersRequest)) {
            return false;
        }
        SearchWorkersRequest other = (SearchWorkersRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && this.hasFleetIds() == other.hasFleetIds() && Objects.equals(this.fleetIds(), other.fleetIds()) && Objects.equals(this.filterExpressions(), other.filterExpressions()) && this.hasSortExpressions() == other.hasSortExpressions() && Objects.equals(this.sortExpressions(), other.sortExpressions()) && Objects.equals(this.itemOffset(), other.itemOffset()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"SearchWorkersRequest").add("FarmId", (Object)this.farmId()).add("FleetIds", this.hasFleetIds() ? this.fleetIds() : null).add("FilterExpressions", (Object)this.filterExpressions()).add("SortExpressions", this.hasSortExpressions() ? this.sortExpressions() : null).add("ItemOffset", (Object)this.itemOffset()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetIds": {
                return Optional.ofNullable(clazz.cast(this.fleetIds()));
            }
            case "filterExpressions": {
                return Optional.ofNullable(clazz.cast(this.filterExpressions()));
            }
            case "sortExpressions": {
                return Optional.ofNullable(clazz.cast(this.sortExpressions()));
            }
            case "itemOffset": {
                return Optional.ofNullable(clazz.cast(this.itemOffset()));
            }
            case "pageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkersRequest, T> g) {
        return obj -> g.apply((SearchWorkersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();
        private SearchGroupedFilterExpressions filterExpressions;
        private List<SearchSortExpression> sortExpressions = DefaultSdkAutoConstructList.getInstance();
        private Integer itemOffset;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkersRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.fleetIds(model.fleetIds);
            this.filterExpressions(model.filterExpressions);
            this.sortExpressions(model.sortExpressions);
            this.itemOffset(model.itemOffset);
            this.pageSize(model.pageSize);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (this.fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = SearchWorkersRequestFleetIdsListCopier.copy(fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = SearchWorkersRequestFleetIdsListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final SearchGroupedFilterExpressions.Builder getFilterExpressions() {
            return this.filterExpressions != null ? this.filterExpressions.toBuilder() : null;
        }

        public final void setFilterExpressions(SearchGroupedFilterExpressions.BuilderImpl filterExpressions) {
            this.filterExpressions = filterExpressions != null ? filterExpressions.build() : null;
        }

        @Override
        public final Builder filterExpressions(SearchGroupedFilterExpressions filterExpressions) {
            this.filterExpressions = filterExpressions;
            return this;
        }

        public final List<SearchSortExpression.Builder> getSortExpressions() {
            List<SearchSortExpression.Builder> result = SearchSortExpressionsCopier.copyToBuilder(this.sortExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortExpressions(Collection<SearchSortExpression.BuilderImpl> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copyFromBuilder(sortExpressions);
        }

        @Override
        public final Builder sortExpressions(Collection<SearchSortExpression> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copy(sortExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(SearchSortExpression ... sortExpressions) {
            this.sortExpressions(Arrays.asList(sortExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(Consumer<SearchSortExpression.Builder> ... sortExpressions) {
            this.sortExpressions(Stream.of(sortExpressions).map(c -> (SearchSortExpression)((SearchSortExpression.Builder)SearchSortExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getItemOffset() {
            return this.itemOffset;
        }

        public final void setItemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
        }

        @Override
        public final Builder itemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchWorkersRequest build() {
            return new SearchWorkersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchWorkersRequest> {
        public Builder farmId(String var1);

        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder filterExpressions(SearchGroupedFilterExpressions var1);

        default public Builder filterExpressions(Consumer<SearchGroupedFilterExpressions.Builder> filterExpressions) {
            return this.filterExpressions((SearchGroupedFilterExpressions)((SearchGroupedFilterExpressions.Builder)SearchGroupedFilterExpressions.builder().applyMutation(filterExpressions)).build());
        }

        public Builder sortExpressions(Collection<SearchSortExpression> var1);

        public Builder sortExpressions(SearchSortExpression ... var1);

        public Builder sortExpressions(Consumer<SearchSortExpression.Builder> ... var1);

        public Builder itemOffset(Integer var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

