/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityErrorsCopier;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityListCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.GetJobEntityError;
import software.amazon.awssdk.services.deadline.model.JobEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetJobEntityResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, BatchGetJobEntityResponse> {
    private static final SdkField<List<JobEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(BatchGetJobEntityResponse.getter(BatchGetJobEntityResponse::entities)).setter(BatchGetJobEntityResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetJobEntityError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetJobEntityResponse.getter(BatchGetJobEntityResponse::errors)).setter(BatchGetJobEntityResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetJobEntityError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, ERRORS_FIELD));
    private final List<JobEntity> entities;
    private final List<GetJobEntityError> errors;

    private BatchGetJobEntityResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.errors = builder.errors;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<JobEntity> entities() {
        return this.entities;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<GetJobEntityError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobEntityResponse)) {
            return false;
        }
        BatchGetJobEntityResponse other = (BatchGetJobEntityResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetJobEntityResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobEntityResponse, T> g) {
        return obj -> g.apply((BatchGetJobEntityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<JobEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private List<GetJobEntityError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobEntityResponse model) {
            super(model);
            this.entities(model.entities);
            this.errors(model.errors);
        }

        public final List<JobEntity.Builder> getEntities() {
            List<JobEntity.Builder> result = BatchGetJobEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<JobEntity.BuilderImpl> entities) {
            this.entities = BatchGetJobEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<JobEntity> entities) {
            this.entities = BatchGetJobEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(JobEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<JobEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (JobEntity)((JobEntity.Builder)JobEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetJobEntityError.Builder> getErrors() {
            List<GetJobEntityError.Builder> result = BatchGetJobEntityErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetJobEntityError.BuilderImpl> errors) {
            this.errors = BatchGetJobEntityErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetJobEntityError> errors) {
            this.errors = BatchGetJobEntityErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetJobEntityError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetJobEntityError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetJobEntityError)((GetJobEntityError.Builder)GetJobEntityError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetJobEntityResponse build() {
            return new BatchGetJobEntityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetJobEntityResponse> {
        public Builder entities(Collection<JobEntity> var1);

        public Builder entities(JobEntity ... var1);

        public Builder entities(Consumer<JobEntity.Builder> ... var1);

        public Builder errors(Collection<GetJobEntityError> var1);

        public Builder errors(GetJobEntityError ... var1);

        public Builder errors(Consumer<GetJobEntityError.Builder> ... var1);
    }
}

