/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.JobMember;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;

public class ListJobMembersIterable
implements SdkIterable<ListJobMembersResponse> {
    private final DeadlineClient client;
    private final ListJobMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobMembersIterable(DeadlineClient client, ListJobMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobMembersResponseFetcher();
    }

    public Iterator<ListJobMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobMember> members() {
        Function<ListJobMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobMembersResponseFetcher
    implements SyncPageFetcher<ListJobMembersResponse> {
        private ListJobMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListJobMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobMembersResponse nextPage(ListJobMembersResponse previousPage) {
            if (previousPage == null) {
                return ListJobMembersIterable.this.client.listJobMembers(ListJobMembersIterable.this.firstRequest);
            }
            return ListJobMembersIterable.this.client.listJobMembers((ListJobMembersRequest)((Object)ListJobMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

