/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.waiters.DeadlineAsyncWaiter;
import software.amazon.awssdk.services.deadline.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultDeadlineAsyncWaiter
implements DeadlineAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final DeadlineAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetFleetResponse> fleetActiveWaiter;
    private final AsyncWaiter<GetJobResponse> jobCreateCompleteWaiter;
    private final AsyncWaiter<GetLicenseEndpointResponse> licenseEndpointDeletedWaiter;
    private final AsyncWaiter<GetLicenseEndpointResponse> licenseEndpointValidWaiter;
    private final AsyncWaiter<GetQueueFleetAssociationResponse> queueFleetAssociationStoppedWaiter;
    private final AsyncWaiter<GetQueueResponse> queueSchedulingWaiter;
    private final AsyncWaiter<GetQueueResponse> queueSchedulingBlockedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultDeadlineAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DeadlineAsyncClient)DeadlineAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fleetActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetFleetResponse.class).acceptors(DefaultDeadlineAsyncWaiter.fleetActiveWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.fleetActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.jobCreateCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetJobResponse.class).acceptors(DefaultDeadlineAsyncWaiter.jobCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.jobCreateCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.licenseEndpointDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLicenseEndpointResponse.class).acceptors(DefaultDeadlineAsyncWaiter.licenseEndpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.licenseEndpointDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.licenseEndpointValidWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLicenseEndpointResponse.class).acceptors(DefaultDeadlineAsyncWaiter.licenseEndpointValidWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.licenseEndpointValidWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.queueFleetAssociationStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetQueueFleetAssociationResponse.class).acceptors(DefaultDeadlineAsyncWaiter.queueFleetAssociationStoppedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.queueFleetAssociationStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.queueSchedulingWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetQueueResponse.class).acceptors(DefaultDeadlineAsyncWaiter.queueSchedulingWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.queueSchedulingWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.queueSchedulingBlockedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetQueueResponse.class).acceptors(DefaultDeadlineAsyncWaiter.queueSchedulingBlockedWaiterAcceptors())).overrideConfiguration(DefaultDeadlineAsyncWaiter.queueSchedulingBlockedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(GetFleetRequest getFleetRequest) {
        return this.fleetActiveWaiter.runAsync(() -> this.client.getFleet(this.applyWaitersUserAgent(getFleetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(GetFleetRequest getFleetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetActiveWaiter.runAsync(() -> this.client.getFleet(this.applyWaitersUserAgent(getFleetRequest)), DefaultDeadlineAsyncWaiter.fleetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(GetJobRequest getJobRequest) {
        return this.jobCreateCompleteWaiter.runAsync(() -> this.client.getJob(this.applyWaitersUserAgent(getJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(GetJobRequest getJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.jobCreateCompleteWaiter.runAsync(() -> this.client.getJob(this.applyWaitersUserAgent(getJobRequest)), DefaultDeadlineAsyncWaiter.jobCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        return this.licenseEndpointDeletedWaiter.runAsync(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.licenseEndpointDeletedWaiter.runAsync(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)), DefaultDeadlineAsyncWaiter.licenseEndpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        return this.licenseEndpointValidWaiter.runAsync(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.licenseEndpointValidWaiter.runAsync(() -> this.client.getLicenseEndpoint(this.applyWaitersUserAgent(getLicenseEndpointRequest)), DefaultDeadlineAsyncWaiter.licenseEndpointValidWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        return this.queueFleetAssociationStoppedWaiter.runAsync(() -> this.client.getQueueFleetAssociation(this.applyWaitersUserAgent(getQueueFleetAssociationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueFleetAssociationStoppedWaiter.runAsync(() -> this.client.getQueueFleetAssociation(this.applyWaitersUserAgent(getQueueFleetAssociationRequest)), DefaultDeadlineAsyncWaiter.queueFleetAssociationStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(GetQueueRequest getQueueRequest) {
        return this.queueSchedulingWaiter.runAsync(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueSchedulingWaiter.runAsync(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)), DefaultDeadlineAsyncWaiter.queueSchedulingWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest) {
        return this.queueSchedulingBlockedWaiter.runAsync(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.queueSchedulingBlockedWaiter.runAsync(() -> this.client.getQueue(this.applyWaitersUserAgent(getQueueRequest)), DefaultDeadlineAsyncWaiter.queueSchedulingBlockedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetFleetResponse>> fleetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFleetResponse>> result = new ArrayList<WaiterAcceptor<? super GetFleetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetJobResponse>> jobCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPDATE_SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "UPLOAD_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("lifecycleStatus").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLicenseEndpointResponse>> licenseEndpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDeadlineAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "NOT_READY");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLicenseEndpointResponse>> licenseEndpointValidWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetLicenseEndpointResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "NOT_READY");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueFleetAssociationResponse>> queueFleetAssociationStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueFleetAssociationResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueFleetAssociationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueResponse>> queueSchedulingWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SCHEDULING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetQueueResponse>> queueSchedulingBlockedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetQueueResponse>> result = new ArrayList<WaiterAcceptor<? super GetQueueResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SCHEDULING_BLOCKED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fleetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration jobCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration licenseEndpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(234);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration licenseEndpointValidWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(114);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueFleetAssociationStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueSchedulingWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(70);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration queueSchedulingBlockedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DeadlineAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DeadlineRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DeadlineRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DeadlineAsyncWaiter.Builder {
        private DeadlineAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public DeadlineAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public DeadlineAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DeadlineAsyncWaiter.Builder client(DeadlineAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DeadlineAsyncWaiter build() {
            return new DefaultDeadlineAsyncWaiter(this);
        }
    }
}

