/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueueEnvironmentsRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, ListQueueEnvironmentsRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(ListQueueEnvironmentsRequest.getter(ListQueueEnvironmentsRequest::farmId)).setter(ListQueueEnvironmentsRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListQueueEnvironmentsRequest.getter(ListQueueEnvironmentsRequest::maxResults)).setter(ListQueueEnvironmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQueueEnvironmentsRequest.getter(ListQueueEnvironmentsRequest::nextToken)).setter(ListQueueEnvironmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(ListQueueEnvironmentsRequest.getter(ListQueueEnvironmentsRequest::queueId)).setter(ListQueueEnvironmentsRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, QUEUE_ID_FIELD));
    private final String farmId;
    private final Integer maxResults;
    private final String nextToken;
    private final String queueId;

    private ListQueueEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.queueId = builder.queueId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String queueId() {
        return this.queueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueEnvironmentsRequest)) {
            return false;
        }
        ListQueueEnvironmentsRequest other = (ListQueueEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.queueId(), other.queueId());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueueEnvironmentsRequest").add("FarmId", (Object)this.farmId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("QueueId", (Object)this.queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueEnvironmentsRequest, T> g) {
        return obj -> g.apply((ListQueueEnvironmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private Integer maxResults;
        private String nextToken;
        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueEnvironmentsRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.queueId(model.queueId);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueueEnvironmentsRequest build() {
            return new ListQueueEnvironmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueueEnvironmentsRequest> {
        public Builder farmId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder queueId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

