/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParameterGroupResponse extends DaxResponse implements
        ToCopyableBuilder<CreateParameterGroupResponse.Builder, CreateParameterGroupResponse> {
    private static final SdkField<ParameterGroup> PARAMETER_GROUP_FIELD = SdkField
            .<ParameterGroup> builder(MarshallingType.SDK_POJO).memberName("ParameterGroup")
            .getter(getter(CreateParameterGroupResponse::parameterGroup)).setter(setter(Builder::parameterGroup))
            .constructor(ParameterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ParameterGroup parameterGroup;

    private CreateParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.parameterGroup = builder.parameterGroup;
    }

    /**
     * <p>
     * Represents the output of a <i>CreateParameterGroup</i> action.
     * </p>
     * 
     * @return Represents the output of a <i>CreateParameterGroup</i> action.
     */
    public final ParameterGroup parameterGroup() {
        return parameterGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParameterGroupResponse)) {
            return false;
        }
        CreateParameterGroupResponse other = (CreateParameterGroupResponse) obj;
        return Objects.equals(parameterGroup(), other.parameterGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateParameterGroupResponse").add("ParameterGroup", parameterGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroup":
            return Optional.ofNullable(clazz.cast(parameterGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterGroup", PARAMETER_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateParameterGroupResponse, T> g) {
        return obj -> g.apply((CreateParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DaxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateParameterGroupResponse> {
        /**
         * <p>
         * Represents the output of a <i>CreateParameterGroup</i> action.
         * </p>
         * 
         * @param parameterGroup
         *        Represents the output of a <i>CreateParameterGroup</i> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroup(ParameterGroup parameterGroup);

        /**
         * <p>
         * Represents the output of a <i>CreateParameterGroup</i> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterGroup.Builder} avoiding the need
         * to create one manually via {@link ParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #parameterGroup(ParameterGroup)}.
         * 
         * @param parameterGroup
         *        a consumer that will call methods on {@link ParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterGroup(ParameterGroup)
         */
        default Builder parameterGroup(Consumer<ParameterGroup.Builder> parameterGroup) {
            return parameterGroup(ParameterGroup.builder().applyMutation(parameterGroup).build());
        }
    }

    static final class BuilderImpl extends DaxResponse.BuilderImpl implements Builder {
        private ParameterGroup parameterGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParameterGroupResponse model) {
            super(model);
            parameterGroup(model.parameterGroup);
        }

        public final ParameterGroup.Builder getParameterGroup() {
            return parameterGroup != null ? parameterGroup.toBuilder() : null;
        }

        public final void setParameterGroup(ParameterGroup.BuilderImpl parameterGroup) {
            this.parameterGroup = parameterGroup != null ? parameterGroup.build() : null;
        }

        @Override
        public final Builder parameterGroup(ParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        @Override
        public CreateParameterGroupResponse build() {
            return new CreateParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
