/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dax.model.Endpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(Node.getter(Node::nodeId)).setter(Node.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(Node.getter(Node::endpoint)).setter(Node.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> NODE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NodeCreateTime").getter(Node.getter(Node::nodeCreateTime)).setter(Node.setter(Builder::nodeCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCreateTime").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Node.getter(Node::availabilityZone)).setter(Node.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> NODE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeStatus").getter(Node.getter(Node::nodeStatus)).setter(Node.setter(Builder::nodeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeStatus").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupStatus").getter(Node.getter(Node::parameterGroupStatus)).setter(Node.setter(Builder::parameterGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, ENDPOINT_FIELD, NODE_CREATE_TIME_FIELD, AVAILABILITY_ZONE_FIELD, NODE_STATUS_FIELD, PARAMETER_GROUP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NodeId", NODE_ID_FIELD);
            this.put("Endpoint", ENDPOINT_FIELD);
            this.put("NodeCreateTime", NODE_CREATE_TIME_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("NodeStatus", NODE_STATUS_FIELD);
            this.put("ParameterGroupStatus", PARAMETER_GROUP_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final Endpoint endpoint;
    private final Instant nodeCreateTime;
    private final String availabilityZone;
    private final String nodeStatus;
    private final String parameterGroupStatus;

    private Node(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.endpoint = builder.endpoint;
        this.nodeCreateTime = builder.nodeCreateTime;
        this.availabilityZone = builder.availabilityZone;
        this.nodeStatus = builder.nodeStatus;
        this.parameterGroupStatus = builder.parameterGroupStatus;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final Instant nodeCreateTime() {
        return this.nodeCreateTime;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String nodeStatus() {
        return this.nodeStatus;
    }

    public final String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.nodeCreateTime(), other.nodeCreateTime()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.nodeStatus(), other.nodeStatus()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("NodeId", (Object)this.nodeId()).add("Endpoint", (Object)this.endpoint()).add("NodeCreateTime", (Object)this.nodeCreateTime()).add("AvailabilityZone", (Object)this.availabilityZone()).add("NodeStatus", (Object)this.nodeStatus()).add("ParameterGroupStatus", (Object)this.parameterGroupStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "NodeCreateTime": {
                return Optional.ofNullable(clazz.cast(this.nodeCreateTime()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "NodeStatus": {
                return Optional.ofNullable(clazz.cast(this.nodeStatus()));
            }
            case "ParameterGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeId;
        private Endpoint endpoint;
        private Instant nodeCreateTime;
        private String availabilityZone;
        private String nodeStatus;
        private String parameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.nodeId(model.nodeId);
            this.endpoint(model.endpoint);
            this.nodeCreateTime(model.nodeCreateTime);
            this.availabilityZone(model.availabilityZone);
            this.nodeStatus(model.nodeStatus);
            this.parameterGroupStatus(model.parameterGroupStatus);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getNodeCreateTime() {
            return this.nodeCreateTime;
        }

        public final void setNodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
        }

        @Override
        public final Builder nodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getNodeStatus() {
            return this.nodeStatus;
        }

        public final void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        @Override
        public final Builder nodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
            return this;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder nodeId(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder nodeCreateTime(Instant var1);

        public Builder availabilityZone(String var1);

        public Builder nodeStatus(String var1);

        public Builder parameterGroupStatus(String var1);
    }
}

