/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dax.DaxClient;
import software.amazon.awssdk.services.dax.DaxClientBuilder;
import software.amazon.awssdk.services.dax.DaxServiceClientConfiguration;
import software.amazon.awssdk.services.dax.DefaultDaxBaseClientBuilder;
import software.amazon.awssdk.services.dax.DefaultDaxClient;
import software.amazon.awssdk.services.dax.endpoints.DaxEndpointProvider;

@SdkInternalApi
final class DefaultDaxClientBuilder
extends DefaultDaxBaseClientBuilder<DaxClientBuilder, DaxClient>
implements DaxClientBuilder {
    DefaultDaxClientBuilder() {
    }

    @Override
    public DefaultDaxClientBuilder endpointProvider(DaxEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DaxClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDaxClientBuilder.validateClientOptions(clientConfiguration);
        DaxServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDaxClient client = new DefaultDaxClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DaxServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DaxServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

