/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.DaxResponse;
import software.amazon.awssdk.services.dax.model.ParameterGroup;
import software.amazon.awssdk.services.dax.model.ParameterGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeParameterGroupsResponse
extends DaxResponse
implements ToCopyableBuilder<Builder, DescribeParameterGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeParameterGroupsResponse.getter(DescribeParameterGroupsResponse::nextToken)).setter(DescribeParameterGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ParameterGroup>> PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterGroups").getter(DescribeParameterGroupsResponse.getter(DescribeParameterGroupsResponse::parameterGroups)).setter(DescribeParameterGroupsResponse.setter(Builder::parameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PARAMETER_GROUPS_FIELD));
    private final String nextToken;
    private final List<ParameterGroup> parameterGroups;

    private DescribeParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.parameterGroups = builder.parameterGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasParameterGroups() {
        return this.parameterGroups != null && !(this.parameterGroups instanceof SdkAutoConstructList);
    }

    public final List<ParameterGroup> parameterGroups() {
        return this.parameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterGroups() ? this.parameterGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsResponse)) {
            return false;
        }
        DescribeParameterGroupsResponse other = (DescribeParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasParameterGroups() == other.hasParameterGroups() && Objects.equals(this.parameterGroups(), other.parameterGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeParameterGroupsResponse").add("NextToken", (Object)this.nextToken()).add("ParameterGroups", this.hasParameterGroups() ? this.parameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.parameterGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DaxResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ParameterGroup> parameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.parameterGroups(model.parameterGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<ParameterGroup.Builder> getParameterGroups() {
            List<ParameterGroup.Builder> result = ParameterGroupListCopier.copyToBuilder(this.parameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameterGroups(Collection<ParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ParameterGroup ... parameterGroups) {
            this.parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ParameterGroup.Builder> ... parameterGroups) {
            this.parameterGroups(Stream.of(parameterGroups).map(c -> (ParameterGroup)((ParameterGroup.Builder)ParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterGroups(Collection<ParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public DescribeParameterGroupsResponse build() {
            return new DescribeParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DaxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeParameterGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder parameterGroups(Collection<ParameterGroup> var1);

        public Builder parameterGroups(ParameterGroup ... var1);

        public Builder parameterGroups(Consumer<ParameterGroup.Builder> ... var1);
    }
}

