/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationConfiguration> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(NotificationConfiguration.getter(NotificationConfiguration::topicArn)).setter(NotificationConfiguration.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> TOPIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicStatus").getter(NotificationConfiguration.getter(NotificationConfiguration::topicStatus)).setter(NotificationConfiguration.setter(Builder::topicStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, TOPIC_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicArn;
    private final String topicStatus;

    private NotificationConfiguration(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.topicStatus = builder.topicStatus;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String topicStatus() {
        return this.topicStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.topicStatus(), other.topicStatus());
    }

    public String toString() {
        return ToString.builder((String)"NotificationConfiguration").add("TopicArn", (Object)this.topicArn()).add("TopicStatus", (Object)this.topicStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "TopicStatus": {
                return Optional.ofNullable(clazz.cast(this.topicStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String topicStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.topicArn(model.topicArn);
            this.topicStatus(model.topicStatus);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getTopicStatus() {
            return this.topicStatus;
        }

        @Override
        public final Builder topicStatus(String topicStatus) {
            this.topicStatus = topicStatus;
            return this;
        }

        public final void setTopicStatus(String topicStatus) {
            this.topicStatus = topicStatus;
        }

        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationConfiguration> {
        public Builder topicArn(String var1);

        public Builder topicStatus(String var1);
    }
}

