/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of a parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterGroupStatus.Builder, ParameterGroupStatus> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterGroupStatus::parameterGroupName)).setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterGroupStatus::parameterApplyStatus)).setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<List<String>> NODE_IDS_TO_REBOOT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ParameterGroupStatus::nodeIdsToReboot))
            .setter(setter(Builder::nodeIdsToReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToReboot").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD, NODE_IDS_TO_REBOOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterGroupName;

    private final String parameterApplyStatus;

    private final List<String> nodeIdsToReboot;

    private ParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.nodeIdsToReboot = builder.nodeIdsToReboot;
    }

    /**
     * <p>
     * The name of the parameter group.
     * </p>
     * 
     * @return The name of the parameter group.
     */
    public String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     * 
     * @return The status of parameter updates.
     */
    public String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * Returns true if the NodeIdsToReboot property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNodeIdsToReboot() {
        return nodeIdsToReboot != null && !(nodeIdsToReboot instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The node IDs of one or more nodes to be rebooted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodeIdsToReboot()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The node IDs of one or more nodes to be rebooted.
     */
    public List<String> nodeIdsToReboot() {
        return nodeIdsToReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(nodeIdsToReboot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterGroupStatus)) {
            return false;
        }
        ParameterGroupStatus other = (ParameterGroupStatus) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(nodeIdsToReboot(), other.nodeIdsToReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterGroupStatus").add("ParameterGroupName", parameterGroupName())
                .add("ParameterApplyStatus", parameterApplyStatus()).add("NodeIdsToReboot", nodeIdsToReboot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "NodeIdsToReboot":
            return Optional.ofNullable(clazz.cast(nodeIdsToReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterGroupStatus, T> g) {
        return obj -> g.apply((ParameterGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterGroupStatus> {
        /**
         * <p>
         * The name of the parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The status of parameter updates.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of parameter updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The node IDs of one or more nodes to be rebooted.
         * </p>
         * 
         * @param nodeIdsToReboot
         *        The node IDs of one or more nodes to be rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot);

        /**
         * <p>
         * The node IDs of one or more nodes to be rebooted.
         * </p>
         * 
         * @param nodeIdsToReboot
         *        The node IDs of one or more nodes to be rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToReboot(String... nodeIdsToReboot);
    }

    static final class BuilderImpl implements Builder {
        private String parameterGroupName;

        private String parameterApplyStatus;

        private List<String> nodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterGroupStatus model) {
            parameterGroupName(model.parameterGroupName);
            parameterApplyStatus(model.parameterApplyStatus);
            nodeIdsToReboot(model.nodeIdsToReboot);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getNodeIdsToReboot() {
            return nodeIdsToReboot;
        }

        @Override
        public final Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToReboot(String... nodeIdsToReboot) {
            nodeIdsToReboot(Arrays.asList(nodeIdsToReboot));
            return this;
        }

        public final void setNodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
        }

        @Override
        public ParameterGroupStatus build() {
            return new ParameterGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
