/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dax.model.Event;

public class EventUnmarshaller
implements Unmarshaller<Event, JsonUnmarshallerContext> {
    private static final EventUnmarshaller INSTANCE = new EventUnmarshaller();

    public Event unmarshall(JsonUnmarshallerContext context) throws Exception {
        Event.Builder eventBuilder = Event.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SourceName", targetDepth)) {
                    context.nextToken();
                    eventBuilder.sourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    context.nextToken();
                    eventBuilder.sourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    eventBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Date", targetDepth)) {
                    context.nextToken();
                    eventBuilder.date((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Event)eventBuilder.build();
    }

    public static EventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

